% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bw.abram.net.R
\name{bw.abram.net}
\alias{bw.abram.net}
\title{Abramson's adaptive bandwidth for networks}
\usage{
\method{bw.abram}{net}(
  X,
  h0,
  ...,
  at = c("points", "pixels"),
  hp = h0,
  pilot = NULL,
  trim = 5,
  smoother = densityQuick.lpp
)
}
\arguments{
\item{X}{A point pattern on a linear network (object of class "lpp").}

\item{h0}{The global smoothing bandwidth. The default is the maximal oversmoothing principle of Terrell (1990).}

\item{...}{Additional arguments passed to smoother to control the type of smoothing.}

\item{at}{Character string specifying whether to compute bandwidths at the points (at = "points", the default) or to compute bandwidths at every bin in a bin grid (at = "bins").}

\item{hp}{Optional. A scalar pilot bandwidth, used for estimation of the pilot density if required.}

\item{pilot}{Optional. A pilot estimation of the intensity to plug in Abramson's formula.}

\item{trim}{A trimming value to cut extreme large bandwidths.}

\item{smoother}{Smoother for the pilot. A function or character string, specifying the function to be used to compute the pilot estimate when pilot is NULL or is a point pattern.}
}
\value{
If \code{at = "points"} (the default), the result is a numeric vector with one bandwidth for each data point in \code{X}.
If \code{at = "pixels"}, the output is an object with class "linim"
}
\description{
Computes adaptive smoothing bandwidth in the network case according to the inverse-square-root rule of Abramson (1982).
}
\details{
This function returns a set of adaptive smoothing bandwidths driven by Abramson's (1982) method for a point pattern in a linear network.
The bandwidth at location \eqn{u} is given by
\deqn{
\epsilon(u) = h0 * \mbox{min}\left[ \frac{1}{\gamma} \sqrt{\frac{n}{\tilde{lambda}(u)}}, \mbox{\texttt{trim}} \right]
}{
h0 * pmin((pilotvalues ^ (-0.5)) / gamma, trim)
}
where \eqn{\tilde{\lambda}(u)} is a pilot estimate of the network varying intensity and \eqn{\gamma} is a scaling constant depending on the pilot estimate.
}
\examples{
#To be done

}
\references{
Abramson, I. (1982) On bandwidth variation in kernel estimates --- a square root law.
\emph{Annals of Statistics}, \bold{10}(4), 1217-1223.\cr
}
\author{
Jonatan A. González
}
