% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/separability.test.R
\name{separability.test}
\alias{separability.test}
\title{Separability test for spatio-temporal point processes}
\usage{
separability.test(X, t = NULL, nx = NULL, ny = NULL, nt = NULL, nperm = 1000)
}
\arguments{
\item{X}{A spatial point pattern (an object of class \code{ppp}) with the spatial coordinates of the observations.}

\item{t}{A numeric vector of temporal coordinates with equal length to the number of points in \code{X}. This gives the time associated with each spatial point.}

\item{nx, ny, nt}{Numbers of quadrats in the \eqn{x,y} and \eqn{t} directions.}

\item{nperm}{An integer specifying the number of replicates used in the Monte Carlo test.}
}
\value{
A list with class "htest" containing the following components:
\item{p.value}{the approximate p-value of the test.}
\item{method}{the character string "Separability test based on Fisher's for counting data".}
\item{alternative}{a character string describing the alternative hypothesis.}
\item{data.name}{a character string giving the name(s) of the data.}
}
\description{
Performs a separability test of the first-order intensity function based on a Fisher Monte Carlo test of cell counts.
}
\details{
This function performs a basic test of the separability hypothesis in a manner similar to independence test in two-way contingency tables.
The test is conditional on the observed number of points.
It considers a regular division of the interval \eqn{T} into disjoint sub-intervals \eqn{T_1,...,T_{n_t}} and similarly a division of the window \eqn{W} into disjoint subsets \eqn{W_1, ..., W{n_x \times n_y}}.
Then the function computes Fisher's test statistic and get a p-value based on Monte Carlos approximation.
}
\note{
This is a fast preliminary separability test.
}
\examples{
data(lGCpp)
separability.test(lGCpp, nx = 5, ny = 4, nt = 3, nperm = 500)

\donttest{
data(aegiss)
separability.test(aegiss, nx = 8, ny = 8, nt = 4)
}

}
\references{
Ghorbani et al. (2021) Testing the first-order separability hypothesis for spatio-temporal point patterns,
\emph{Computational Statistics & Data Analysis,} \bold{161}, p.107245.
}
\author{
Jonatan A. González
}
