% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/keyToEnglish.R
\name{uniqueness_max_size}
\alias{uniqueness_max_size}
\title{Uniqueness Max Size}
\usage{
uniqueness_max_size(N, p)
}
\arguments{
\item{N}{`numeric` size of set elements are selected from, or a `list` of
`list`s of `character` vectors (e.g., `wml_animals`)}

\item{p}{`numeric` probability that there are any duplicate elements}
}
\value{
`numeric` value indicating size. Value will most likely be non-integer
}
\description{
Returns approximate number of elements that you can select out
of a set of size `N` if the probability of there being any duplicates
is less than or equal to `p`
}
\examples{
# how many values from 1-1,000 can I randomly select before
# I have a 10\% chance of having at least one duplicate?

uniqueness_max_size(1000,0.1)
# 14.51
}
