% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_functions.R
\name{kfino_plot}
\alias{kfino_plot}
\title{kfino_plot a graphical function for the result of a kfino run}
\usage{
kfino_plot(
  resuin,
  typeG,
  Tvar,
  Yvar,
  Ident,
  title = NULL,
  labelX = NULL,
  labelY = NULL
)
}
\arguments{
\item{resuin}{a list resulting of the kfino algorithm}

\item{typeG}{char, type of graphic, either detection of outliers (with
qualitative or quantitative display) or prediction. must be
"quanti" or "quali" or "prediction"}

\item{Tvar}{char, time variable in the data.frame datain}

\item{Yvar}{char, variable which was analysed in the data.frame datain}

\item{Ident}{char, column name of the individual id to be analyzed}

\item{title}{char, a graph title}

\item{labelX}{char, a label for x-axis}

\item{labelY}{char, a label for y-axis}
}
\value{
a ggplot2 graphic
}
\description{
kfino_plot a graphical function for the result of a kfino run
}
\details{
The produced graphic can be, according to typeG:
\describe{
 \item{quali}{This plot shows the detection of outliers with a qualitative 
      rule: OK values (black), KO values (outliers, purple) and OOR values 
      (out of range values defined by the user in `kfino_fit`, red) }
 \item{quanti}{This plot shows the detection of outliers with a quantitative 
      display using the calculated probability of the kfino algorithm}
 \item{prediction}{This plot shows the prediction of the analyzed variable 
       plus the OK values. Prediction corresponds to E[X_{t} | Y_{1...t}] 
       for each time point t. Between 2 time points, we used a simple 
       linear interpolation.}
}
}
\examples{
data(spring1)
library(dplyr)

print(colnames(spring1))

# --- Without Optimisation on initial parameters
param2<-list(m0=41,
             mm=45,
             pp=0.5,
             aa=0.001,
             expertMin=30,
             expertMax=75,
             sigma2_m0=1,
             sigma2_mm=0.05,
             sigma2_pp=5,
             K=2,
             seqp=seq(0.5,0.7,0.1))
resu2<-kfino_fit(datain=spring1,
              Tvar="dateNum",Yvar="Poids",
              param=param2,
              doOptim=FALSE)

# flags are qualitative
kfino_plot(resuin=resu2,typeG="quali",
            Tvar="Day",Yvar="Poids",Ident="IDE",
            title="kfino spring1",
            labelX="Time (day)",labelY="Weight (kg)")

# flags are quantitative
kfino_plot(resuin=resu2,typeG="quanti",
            Tvar="Day",Yvar="Poids",Ident="IDE")

# predictions on OK values
kfino_plot(resuin=resu2,typeG="prediction",
            Tvar="Day",Yvar="Poids",Ident="IDE")
}
