% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kld-analytical.R
\name{kld_gaussian}
\alias{kld_gaussian}
\title{Analytical KL divergence for two uni- or multivariate Gaussian distributions}
\usage{
kld_gaussian(mu1, sigma1, mu2, sigma2)
}
\arguments{
\item{mu1}{A numeric vector (mean of true Gaussian)}

\item{sigma1}{A s.p.d. matrix (Covariance matrix of true Gaussian)}

\item{mu2}{A numeric vector (mean of approximate Gaussian)}

\item{sigma2}{A s.p.d. matrix  (Covariance matrix of approximate Gaussian)}
}
\value{
A scalar (the Kullback-Leibler divergence)
}
\description{
This function computes \eqn{D_{KL}(p||q)}, where \eqn{p\sim \mathcal{N}(\mu_1,\Sigma_1)}
and \eqn{q\sim \mathcal{N}(\mu_2,\Sigma_2)}.
}
\examples{
kld_gaussian(mu1 = 1, sigma1 = 1, mu2 = 1, sigma2 = 2^2)
kld_gaussian(mu1 = rep(0,2), sigma1 = diag(2),
                mu2 = rep(1,2), sigma2 = matrix(c(1,0.5,0.5,1), nrow = 2))
}
