% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/klsh.R
\name{bag_signatures}
\alias{bag_signatures}
\title{Function that reduces a bag of words into a signature matrix using multiple
random projections}
\usage{
bag_signatures(sack_of_bags, p, weighting_table)
}
\arguments{
\item{sack_of_bags}{Sack of bag of words}

\item{p}{Number of random projections p}

\item{weighting_table}{Weighting table (inverse document frequency)}
}
\value{
Computes a signature matrix using multiple random projections and
the inverse document frequency weights
}
\description{
Function that reduces a bag of words into a signature matrix using multiple
random projections
}
\examples{
data(RLdata500)
data.500 <- RLdata500[-c(2,4)]
sack <- sacks_of_bags_of_words(data.500[1:3,c(-2)],k=2)
idf <- calc_idf(sack)
bag_signatures(sack, p=5, idf)
}
