% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/klsh.R
\name{klsh}
\alias{klsh}
\title{Function that reduces a bag of words into a signature matrix using multiple
random projections}
\usage{
klsh(r.set, p, num.blocks, k, fieldwise = FALSE, quiet = TRUE)
}
\arguments{
\item{r.set}{Set of records}

\item{p}{Number of random projections p}

\item{num.blocks}{The total number of desired blocks}

\item{k}{The total number of tokens}

\item{fieldwise}{Flag with default FALSE}

\item{quiet}{Flag to turn on printed progress, default to TRUE}
}
\value{
The blocks from performing KLSH
}
\description{
Function that reduces a bag of words into a signature matrix using multiple
random projections
}
\examples{
data(RLdata500)
data.500 <- RLdata500[-c(2,4)]
klsh.blocks <- klsh(data.500, p=20, num.blocks=5, k=2)
}
