% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sTab.R
\name{sTab}
\alias{sTab}
\title{Produces a latex supertabular environment}
\usage{
sTab(x, label = NULL, caption.top = NULL, caption.bottom = NULL,
  caption.table = NULL, booktabs = .op("kLat.sTab.booktabs",
  "kLat.booktabs", FALSE), toprule = .book("kLat.toprule", booktabs,
  "\\\\toprule", "\\\\hline"), bottomrule = .book("kLat.bottomrule", booktabs,
  "\\\\bottomrule", "\\\\hline"), midrule = .book("kLat.midrule", booktabs,
  "\\\\midrule", "\\\\hline"), align = .op("kLat.sTab.align", "kLat.align",
  "center"), envir = getOption("kLat.sTab.envir", "supertabular"),
  colsep = .op("kLat.sTab.colsep", "kLat.colsep", ""), coldef = .coldef(x,
  colsep), rowsep = .op("kLat.sTab.rowsep", "kLat.rowsep", ""),
  rows = .op("kLat.sTab.rows", "kLat.rows", FALSE), firsthead = NULL,
  head = .header(x, rows), tail = bottomrule, lasttail = NULL)
}
\arguments{
\item{x}{a data.frame or matrix to form the base of the table}

\item{label}{set the table's label, defaults to an empty string}

\item{caption.top}{sets the caption command placing it at the top
  of the table}

\item{caption.bottom}{sets the caption command placing it at the
  bottom of the table}

\item{caption.table}{sets '\\tablecaption' option of supertabular, which
  allows for a default placement of the caption, see supertabular documentation
  for a more detailed explanation.}

\item{booktabs}{logical value, if not set will use value of
  kLat.(xTab|sTab|lTab).booktabs, if not set will use value of kLat.booktabs,
  if not set defaults to FALSE. When TRUE toprule defaults to '\\toprule',
  midrule to '\\midrule', and botrule to '\\bottomrule', when FALSE those
  values all default to '\\hline'. Has no effect when toprule, midrule, and
  botrule are individually set.}

\item{toprule}{sets the value for the top rule, if not set will be
  determined by the value of booktabs}

\item{bottomrule}{sets the value for the bottom rule, if not set will
  be determined by the value of booktabs}

\item{midrule}{sets the value for the mid rule, if not set will
  be determined by the value of booktabs}

\item{align}{set the alignment of the environment, if not set will use value
  of kLat.(xTab|sTab|lTab).align, if not will use value of kLat.align, if not set
  defaults to 'center'}

\item{envir}{set the environment for the table, if not set will use the value
  of kLat.(xTab|sTab|lTab).envir, if not set defaults to 'tabular',
  'supertabular', and 'longtable' for xTab, sTab, and lTab respectively}

\item{colsep}{separator to be used between columns (i.e. '|'), if not set
  will use the value of kLat.(xTab|sTab|lTab).colsep, if not set will use the
  value of kLat.colsep, if not set defaults to an empty string. If coldef is
  set this value is ignored and the separators must be specificed in the coldef}

\item{coldef}{sets column definition i.e. \\begin\{tabular\}\{'align'\},
  if not set defaults to numeric = right, character = left}

\item{rowsep}{the separaotr to be used between rows (i.e. '\\hline'), if not
  set will use the value of kLat.(xTab|sTab|lTab).rowsep, if not set will use
  the value of kLat.rowsep, if not set defaults to an empty string}

\item{rows}{logical value to determine if rownames are included in table, if
  not set will use the value of kLat.(xTab|sTab|lTab).rows, if not set will use
  the value of kLat.rows, if not set defaults to FALSE, if TRUE the column name
  for the rownames column defaults to an empty string}

\item{firsthead}{header on first page of table only}

\item{head}{header to appear at the top of every page of table}

\item{tail}{footer on bottom of every page of table}

\item{lasttail}{footer on last page of table only}
}
\description{
Produces a latex supertabular environment
}
\examples{
sTab(mtcars)
sTab(mtcars,
  caption.top = 'my super table',
  booktabs = TRUE,
  rows = TRUE)
}

