% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kronos.R
\name{fw_kronos}
\alias{fw_kronos}
\title{Fit a cosinor model and extract relevant parameters on a feature table.}
\usage{
fw_kronos(
  x,
  formula,
  metadata,
  time = NULL,
  period = 24,
  verbose = FALSE,
  pairwise = FALSE
)
}
\arguments{
\item{x}{Input data. A table with rows being features and columns being samples}

\item{formula}{A formula. Use the \code{time} function to designate which variable represents time. Leave the left-hand side of the formula empty as it will be sequentially replaced by every feature in the table.}

\item{metadata}{A metadata table, with rows being samples and columns being metadata entries}

\item{time}{A string. Should be the column name containing the time values.}

\item{period}{A numeric. The length of a period, in the same format as the \code{time} parameter.}

\item{verbose}{A boolean. Toggles whether to print diagnostic information while running. Useful for debugging errors on large datasets.}

\item{pairwise}{A boolean. Toggles whether to perform pairwise ANOVAs as a TukeyHSD-like post-hoc.}
}
\value{
A list of \code{kronosOut} S4 objects containing coefficients and all operations.
}
\description{
This wrapper applies kronos(), the main workhorse function in the 'kronos' package. It manages the individual functionalities of 'kronos', including rhythmicity analysis and differential rhythmicity.
}
\examples{
#Load prepared data stored in 'kronos' library
data("kronos_demo")
output <- kronos(formula = Variable_1 ~ time(Timepoint), 
data = onevariable, period = 24, verbose = TRUE, pairwise = FALSE)

#Extracting data from the output object:
getKronos_fit(output)
getKronos_trace(output)
getKronos_groupwise(output)

#Plotting:
gg_kronos_circle(output)
gg_kronos_sinusoid(output)

#For high-dimensional data, use fw_kronos:
out_list = fw_kronos(x = bigdata[1:50,], formula = ~ Group + time(Timepoint), 
metadata = bigmeta, period = 24, verbose = FALSE, pairwise = TRUE) 

#Extracting data from the output object: 
kronosListToTable(out_list)


#Plotting:
gg_kronos_acrogram(out_list)
}
