% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-usage-tracking.R
\name{kvk_usage_report}
\alias{kvk_usage_report}
\title{Generate API usage report for current session}
\usage{
kvk_usage_report(format = "summary")
}
\arguments{
\item{format}{Character string specifying output format:
\itemize{
\item \code{"summary"} (default): Human-readable console output with
costs and call counts for this session
\item \code{"tibble"}: Structured summary data as a tibble
\item \code{"detailed"}: Detailed data with one row per API call, suitable
for analysis and visualization
}}
}
\value{
\itemize{
\item \code{format = "summary"}: Invisible NULL (output printed to console)
\item \code{format = "tibble"}: A tibble with session usage summary
\item \code{format = "detailed"}: A tibble with detailed call-by-call data
}
}
\description{
Display or return API usage statistics and costs for the current R session.
This function helps you monitor your KvK API usage and associated costs.
}
\details{
The summary format displays API call counts and costs for the current R session only.
All usage data is session-based and will be reset when you restart R.
Search calls are free, while profile calls cost EUR 0.02 each.

Only production API calls are included in reports. Test environment calls are not tracked.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Display human-readable summary
kvk_usage_report()

# Get structured summary as tibble
summary_data <- kvk_usage_report(format = "tibble")
print(summary_data)

# Get detailed call data for custom analysis
call_data <- kvk_usage_report(format = "detailed")
head(call_data)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link{kvk_usage_alert}} for setting usage limits,
\code{\link{kvk_export_usage}} for exporting data to CSV,
\code{\link{kvk_reset_usage}} for clearing usage history
}
