% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multigmmsamedistribu.R
\name{multigmmsamedistribu}
\alias{multigmmsamedistribu}
\title{Fit Multi 2-Component Gaussian Mixture Model in same distribution with a Fixed Proportion}
\usage{
multigmmsamedistribu(x, lambda_lower = 0.1, lambda_upper = 1 - lambda_lower,
  sigma_lower = 0.01, debug = F)
}
\arguments{
\item{x}{a list of numeric vector}

\item{lambda_lower}{the lower bound of \eqn{\lambda}}

\item{lambda_upper}{the upper bound of \eqn{\lambda}}

\item{sigma_lower}{the lower bound of \eqn{\sigma}}

\item{debug}{enable the debug mode to show \code{par} and \code{fn}}
}
\description{
Fit Multi 2-Component Gaussian Mixture Model in same distribution with a Fixed Proportion
}
\examples{
set.seed(0)
x1=c(rnorm(150, mean=0), rnorm(50, mean=10))
x2=c(rnorm(150, mean=20), rnorm(50, mean=40))
x3=c(rnorm(150, mean=30), rnorm(50, mean=60))
x=list(x1, x2, x3)
multigmmsamedistribu(x)
}
\keyword{distribution}
