% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smerge.R
\name{smerge}
\alias{smerge}
\title{Safely Merge Two Data Frames}
\usage{
smerge(x, y, ...)
}
\arguments{
\item{x}{a data.frame to be merged with y.}

\item{y}{a data.frame to be merged with x.}

\item{...}{additional arguments passed to \code{base::merge()}}
}
\value{
a data.frame.
}
\description{
\code{smerge} allows one to merge two data.frames, one or both of which may be
labeled, preserving the labelr attributes of the inputted data.frames.
}
\details{
Precedence is given to the labels of the first data.frame (argument x), such
that, if both data.frames include a label attribute with the same name, the
attribute from data.frame x will be preserved, and the same-named attribute
from data.frame y will be discarded.
}
\examples{
# assign mtcars to df
df <- mtcars

# assign the rownames to a column
id <- rownames(df)

df <- cbind(id, df)

# split the data.frame into two
df_a <- df[c("id", "am")]
df_b <- df[c("id", "mpg")]

# add value labels to df_a$am
df_a <- add_val_labs(
  data = df_a,
  vars = "am",
  vals = c(0, 1),
  labs = c("automatic", "manual")
)

# add numerical range value labels to df_b$mpg
df_b <- add_quant1(df_b, mpg, qtiles = 4)

# now, safely merge them
df_m <- smerge(df_a, df_b)

head(df_m)

get_val_labs(df_m)
}
