% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/with_name_labs.R
\name{with_name_labs}
\alias{with_name_labs}
\alias{wnl}
\title{Overlay Variable Name Labels Onto Arbitrary R Function Calls}
\usage{
with_name_labs(data, ...)

wnl(data, ...)
}
\arguments{
\item{data}{a data.frame with name labels.}

\item{...}{an additional expression passed to dots (quotes and dollar signs
are not needed or permitted).}
}
\value{
the value of the evaluated \code{expr}, with name labels substituted for
variable (column) names.
}
\description{
\code{with_name_labs} instructs R function calls to swap in variable name labels
for column names in the objects they return or side effects they produce.
}
\details{
Note: \code{wnl} is a compact alias for \code{with_name_labs}: they do the same thing,
and the former is easier to type

\code{with_name_labs} is intended for interactive use. With it, you pass a
name-labeled data.frame, followed by a comma, followed by an unquoted R
expression (function call) to be evaluated within that data.frame, and name
labels will be substituted for column names in any returned object or side
effects. Your function call (expression) should refer to columns of the
data.frame, NOT their name labels, as the intent is to allow you to pass
functions in terms of the (typically much more concise and familiar) column
names while having the results displayed / presented in terms of the more
informative (but more verbose and typically non-standard) name labels.
See examples.

Caution: \code{with_name_labs} is a rudimentary function that leverages basic,
fairly literal (and potentially brittle!) regular expressions and
\code{eval(parse(text=))} to substitute name labels for variable names behind the
scenes. It appears to be robust to a range of common commands and operators
(e.g., ~ , * , +, :, ::, =, and |). However, it is intended strictly as a
convenience for relatively simple, interactive, single-line-expression use
cases, involving data exploration, description, or simple model-fitting. It
is expressly NOT intended for: (1) multi-step workflows or pipes, (2)
expressions that require or make  reference to objects existing outside the
supplied data.frame, or (3) data management operations aimed at modifying
(e.g., subsetting, merging, renaming) -- as opposed to merely describing or
analyzing -- the supplied data.frame. Again, see the examples for the types
of expressions/use cases envisioned.
}
\examples{
# assign mtcars to new data.frame mt2
mt2 <- mtcars

# add name labs
mt2 <- add_name_labs(mt2,
  name.labs = c(
    "mpg" = "Miles/(US) gallon",
    "cyl" = "Number of cylinders",
    "disp" = "Displacement (cu.in.)",
    "hp" = "Gross horsepower",
    "drat" = "Rear axle ratio",
    "wt" = "Weight (1000 lbs)",
    "qsec" = "1/4 mile time",
    "vs" = "Engine (0 = V-shaped, 1 = straight)",
    "am" = "Transmission (0 = automatic, 1 = manual)",
    "gear" = "Number of forward gears",
    "carb" = "Number of carburetors"
  )
)


with_name_labs(mt2, t.test(mpg ~ am))
with_name_labs(mt2, lm(mpg ~ am))
with_name_labs(mt2, summary(mt2))
with_name_labs(mt2, cor(mt2, use = "pairwise.complete.obs"))
with_name_labs(mt2, xtabs(~gear))
xtabs(~ mt2$gear)
with_name_labs(mt2, cor(mpg, carb))
with_name_labs(mt2, hist(mpg))
with_name_labs(mt2, plot(mpg, carb))
with_name_labs(mt2, head(gear))
with_name_labs(mt2, summary(mt2))
}
