% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lang-help.R
\name{lang_help}
\alias{lang_help}
\title{Translates help documentation to another language}
\usage{
lang_help(topic, package = NULL, lang = NULL, type = getOption("help_type"))
}
\arguments{
\item{topic}{A character vector of the topic to search for.}

\item{package}{The R package to look for the topic, if not provided the
function will attempt to find the topic based on the loaded packages.}

\item{lang}{A character vector language to translate the topic to}

\item{type}{Produce "html" or "text" output for the help. It defaults to
\code{getOption("help_type")}}
}
\value{
Original or translated version of the help documentation in the
output type specified
}
\description{
Translates a given topic into a target language. It uses the \code{lang} argument
to determine which language to translate to. If not passed, this function will
look for a target language in the LANG and LANGUAGE environment variables, or
if something has been passed to the \code{.lang} argument in \code{lang_use()}, to
determine the target language. If the target language is English, no translation
will be processed, so the help returned will be the original package's
documentation.
}
\examples{
\donttest{
library(lang)

lang_use("ollama", "llama3.2", seed = 100)

lang_help("lang_help", lang = "spanish", type = "text")
}

}
