% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_local_dependence.R
\name{add_local_dependence}
\alias{add_local_dependence}
\title{Adds Local Dependence to \code{\link[latentFactoR]{simulate_factors}} Data}
\usage{
add_local_dependence(
  lf_object,
  method = c("correlate_residuals", "minor_factors", "threshold_shifts"),
  proportion_LD,
  proportion_LD_range = NULL,
  add_residuals = NULL,
  add_residuals_range = NULL,
  allow_multiple = FALSE
)
}
\arguments{
\item{lf_object}{Data object from \code{\link[latentFactoR]{simulate_factors}}}

\item{method}{Character (length = 1).
Method to generate local dependence between variables.
Only \code{"correlate_residuals"} at the moment.
Future developments will include minor factor
and threshold-shift methods. Description of methods:

\itemize{

\item \code{"correlate_residuals"} --- Adds residuals directly to the population
correlation matrix prior to data generation (uses population correlation matrix
from \code{\link[latentFactoR]{simulate_factors}})

\item \code{"minor_factors"} --- Coming soon...

\item \code{"threshold_shifts"} --- Coming soon...

}}

\item{proportion_LD}{Numeric (length = 1 or \code{factors}).
Proportion of variables that should be locally dependent across all
or each factor. Accepts number of locally dependent values as well}

\item{proportion_LD_range}{Numeric (length = 2).
Range of proportion of variables that are randomly selected from
a random uniform distribution. Accepts number of locally dependent values as well.
Defaults to \code{NULL}}

\item{add_residuals}{Numeric (length = 1, \code{factors}, or total number of locally dependent variables).
Amount of residual to add to the population correlation matrix between two variables.
Only used when \code{method = "correlated_residuals"}. Magnitudes are drawn from
a random uniform distribution using +/- 0.05 of value input.
Can also be specified directly (same length as total number of locally dependent variables).
General effect sizes range from small (0.20), moderate (0.30), to large (0.40)}

\item{add_residuals_range}{Numeric (length = 2).
Range of the residuals to add to the correlation matrix are randomly selected from
a random uniform distribution.
Defaults to \code{NULL}}

\item{allow_multiple}{Boolean.
Whether a variable should be allowed to be locally dependent with
more than one other variable.
Defaults to \code{FALSE}.
Set to \code{TRUE} for more complex locally dependence patterns}
}
\value{
Returns a list containing:

\item{data}{Simulated data from the specified factor model}

\item{population_correlation}{Population correlation matrix with local dependence added}

\item{original_correlation}{Original population correlation matrix \emph{before}
local dependence was added}

\item{correlated_residuals}{A data frame with the first two columns specifying
the variables that are locally dependent and the third column specifying the
magnitude of the added residual for each locally dependent pair}

\item{original_results}{Original \code{lf_object} input into function}
}
\description{
Adds local dependence to simulated data from \code{\link[latentFactoR]{simulate_factors}}.
See examples to get started
}
\examples{
# Generate factor data
two_factor <- simulate_factors(
  factors = 2, # factors = 2
  variables = 6, # variables per factor = 6
  loadings = 0.55, # loadings between = 0.45 to 0.65
  cross_loadings = 0.05, # cross-loadings N(0, 0.05)
  correlations = 0.30, # correlation between factors = 0.30
  sample_size = 1000 # number of cases = 1000
)

# Add local dependence
two_factor_LD <- add_local_dependence(
  lf_object = two_factor,
  proportion_LD = 0.25,
  add_residuals = 0.20,
  allow_multiple = FALSE
)

# Randomly vary proportions
two_factor_LD <- add_local_dependence(
  lf_object = two_factor,
  proportion_LD_range = c(0.10, 0.50),
  add_residuals = 0.20,
  allow_multiple = FALSE
)

# Randomly vary residuals
two_factor_LD <- add_local_dependence(
  lf_object = two_factor,
  proportion_LD = 0.25,
  add_residuals_range = c(0.20, 0.40),
  allow_multiple = FALSE
)

# Randomly vary proportions, residuals, and allow multiple
two_factor_LD <- add_local_dependence(
  lf_object = two_factor,
  proportion_LD_range = c(0.10, 0.50),
  add_residuals_range = c(0.20, 0.40),
  allow_multiple = TRUE
)

}
\references{
Christensen, A. P., Garrido, L. E., & Golino, H. (2023).
Unique variable analysis: A network psychometrics method to detect local dependence.
\emph{Multivariate Behavioral Research}, 1–18.
}
\author{
Alexander P. Christensen <alexpaulchristensen@gmail.com>,
Hudson Golino <hfg9s@virginia.edu>,
Luis Eduardo Garrido <luisgarrido@pucmm.edu>
}
