% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppm.R
\name{ppm}
\alias{ppm}
\title{Fitting a Proportional Probability Model}
\usage{
ppm(
  formula.linear,
  data,
  conf.level = 0.95,
  y.order = NULL,
  startval = NULL,
  less.than.0 = TRUE,
  control.list = NULL,
  eps.outer = NULL,
  ...
)
}
\arguments{
\item{formula.linear}{an object of class "formula": a symbolic description of the linear model to be fitted.}

\item{data}{dataframe containing the data in linear model.}

\item{conf.level}{optional confidence level (1-alpha) defaulted to 0.95.}

\item{y.order}{optional if y contains ordered integer categories 1:J. If y is not ordered integer 1:J then this is a vector with the ordinal values for y ranging from the lowest to largest ordinal outcome. See Examples below.}

\item{startval}{optional vector of the starting values.}

\item{less.than.0}{optional logical for constraint cut_j <= 0 for all j=1:(J-1). Default is TRUE.}

\item{control.list}{optional list of controls for constrOptim.}

\item{eps.outer}{option for constrOptim.}

\item{...}{Additional arguments for built in functions.}
}
\value{
list of class "ppm" is returned containing:
\item{coefficients}{vector of the estimate of cut_j and beta}
\item{se}{vector of the estimate of standard errors}
\item{vcov}{matrix of the inverse of the negative Hessian}
\item{fitted.values}{matrix of unique covariates and the corresponding estimate of the cumulative probabilities: exp(X \%*\% coefficients)}
\item{loglik}{numerical value of the log-likelihood at the maximum likelihood estimate}
\item{barrier.value}{value of mu in the log-barrier algorithm}
\item{outer.iterations}{value of the number of outer iterations}
\item{formula}{formula in the call of ppm}
\item{startvalues}{vector of the starting values for constrained optimization algorithm}
}
\description{
\code{ppm} provides the maximum likelihood estimate for ordinal outcomes (J>2 categories) and a Generalized Linear Model with the log link with the assumption of proportionality. That is, ppm determines the MLE for log[P(y <= j)]= cut_j + X beta subject to [cut_{j-1} <= cut_j ] and [cut_j + X beta <=0]. This implementation uses \code{\link{constrOptim}} to determine the MLE and so the results should correctly account for the restricted parameter space. A proposed test for proportionality is included in \code{\link{lcpm}}.
}
\note{
A warning of MLE close to the boundary must be carefully considered. Data may have some structure that requires attention.  Additionally, there is no imputation. Any NA results in complete row removal.
}
\examples{
# 2 examples below showing the use of y.order if outcome are not integers 1:J.

# Example 1:

var_a <- c(rep(0,60),rep(1,60))
var_b <- c(rep(0,90),rep(1,30))
y1<-c(rep(2,5),rep(3,10),rep(5,5),rep(10,10),
rep(2,5),rep(3,10),rep(5,10),rep(10,5),
rep(2,10),rep(3,5),rep(5,5),rep(10,10),
rep(2,10),rep(3,5),rep(5,10),rep(10,5))

testdata<-data.frame(y=y1,var_a=var_a,var_b=var_b)

# PPM estimates for proportional model
test1<-ppm( y ~ var_a + var_b, data=testdata, y.order=c(2,3,5,10))
summary(test1)

# Example 2:

y2<-c(rep("a",5),rep("b",10),rep("c",5),rep("d",10),
rep("a",5),rep("b",10),rep("c",10),rep("d",5),
rep("a",10),rep("b",5),rep("c",5),rep("d",10),
rep("a",10),rep("b",5),rep("c",10),rep("d",5))
testdata2<-data.frame(y=y2,var_a=var_a,var_b=var_b)
test2<-ppm(y~var_a + var_b , data=testdata2, y.order=c("a","b","c","d"))
summary(test2)
}
\references{
Singh, G; Fick, G.H. (accepted) Ordinal outcomes: a cumulative probability model with the log link and an assumption of proportionality. Statistics in Medicine.
}
\seealso{
\code{\link{lcpm}}
}
