% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anypfcdfdiscrete.R
\name{cdfd}
\alias{cdfd}
\title{Plot of cumulative distribution function of any discrete variable}
\usage{
cdfd(x, fda, main = NULL, xlab = NULL, ylab = NULL)
}
\arguments{
\item{x}{numeric vector of values of \eqn{X}. See \strong{Details}.}

\item{fda}{numeric vector of \eqn{F_X(x)}. See \strong{Details}.}

\item{main}{main title for the plot.}

\item{xlab}{a label for the x axis.}

\item{ylab}{a label for the y axis.}
}
\value{
The output is plot of distribution function. See \emph{Example 1}.
}
\description{
Help in building the plot of the cumulative distribution function of any discrete variable
}
\details{
Consider the \eqn{X} distribution:\tabular{rccccc}{
   \eqn{p_X(x)}: \tab 0.23 \tab 0.27 \tab 0.30 \tab 0.12 \tab 0.08 \cr
   \eqn{x}: \tab 1 \tab 2 \tab 3 \tab 4 \tab 5 \cr
}


where \eqn{p_X(x)} and \eqn{x} are probability function and values of \eqn{X}. Consider also the \eqn{X} distribution function:

\deqn{
F_X(x) = \left\{\begin{array}{ll}
0, & \textrm{if } x < 1;\\
0.23, & \textrm{if } 1 \leq x < 2;\\
0.50, & \textrm{if } 2 \leq x < 3;\\
0.80, & \textrm{if } 3 \leq x < 4;\\
0.92, & \textrm{if } 4 \leq x < 5;\\
1.00 & \textrm{if } x \geq 5.\\
\end{array}\right.
}

This way, the \code{cdfd} function  needs to consider only the vectors \code{x <- 1:5} and
\code{fda <- c(0.23, 0.50, 0.80, 0.92, 1)}, that is, only the equality conditions for \eqn{x}. See \emph{Example 1}.
}
\examples{
# Example 1
x <- 1:5
fda <- c(0.23, 0.5, 0.8, 0.92, 1)
cdfd(x, fda)
}
