% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper-functions.R
\name{rbf}
\alias{rbf}
\title{RBF kernel - L2 norm}
\usage{
rbf(data, center, coeff = 0.01)
}
\arguments{
\item{data}{Data that includes points in shape of \strong{(M x d)}}

\item{center}{A constant point in shape of \strong{(1 x d)}}

\item{coeff}{Coefficient value for RBF kernel}
}
\value{
A numeric vector containing the Radial basis function kernel distance between each point in \strong{data} and \strong{center}.
}
\description{
The default distance function in LESS.
}
\examples{
data <- matrix(1:12, nrow=3)
center <- c(2, 7, 1, 3)
distances <- rbf(data, center)
print(distances)
}
