# lightsf

The `lightsf` package provides a unified collection of **geospatial datasets** designed for **spatial data analysis, geographic visualization**, and **educational purposes** in R. It offers ready-to-use spatial objects in formats such as `sf`, `SpatialPolygons`, `SpatialPoints`, and `data.frame`, ensuring compatibility with both modern and classical spatial workflows.

The datasets included in `lightsf` come from **well-established spatial data packages** such as `spData`, `spdep`, and `maptools`, curated and harmonized for easy access and teaching use. This package helps users explore spatial relationships, perform geostatistical analyses, and visualize spatial structures without needing to preprocess data manually.

# Installation

You can install the `lightsf` package from CRAN with the following R function:

```R
install.packages("lightsf")
```

# Usage

After installation, load the package and start exploring and using its datasets.

```R
library(lightsf)
```

# lightsf Datasets

Below is a list of some of the main datasets included in the package:

- `boston_pts`: Boston housing data with geographic coordinates (506 observations, 20 variables).
- `dc_poly`: Polygon boundaries of Washington D.C. used for spatial analysis and mapping.
- `countries_pts`: A dataset containing latitude, longitude, and names for 245 countries worldwide.
- `mastigouche_poly`: A spatial object containing polygonal data for Mastigouche ecological reserve boundaries.

Each dataset has been formatted to support immediate spatial workflows in R, including use with packages such as `sf`, `spdep`, and `tmap`.

# Dataset Suffixes

Each dataset in `lightsf` is labeled with a *suffix* to indicate its structure and type:

- _pts: Refers to **point-based datasets** that include georeferenced locations, usually represented by latitude and longitude coordinates. 

- _poly: Refers to **polygon-based datasets**, typically representing areas, administrative boundaries, or spatial zones.  

- _points: Refers to **point datasets** similar to _pts, often derived from other spatial sources or including additional spatial or attribute information.  

# Example Code

```R
# Load the package
library(lightsf)

# Load the Boston dataset
data(boston_pts)

# View the first rows
head(boston_pts)

# Display the structure
str(boston_pts)

# Visualize with sf
library(sf)
plot(st_geometry(boston_pts), main = "Boston Housing Spatial Points")

# Load and view polygon data
data(dc_poly)
plot(dc_poly, col = 'lightblue', main = "Washington D.C. Polygons")
```
