% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survival_ln_mixture-predict.R
\name{predict.survival_ln_mixture}
\alias{predict.survival_ln_mixture}
\title{Predict from a Lognormal Mixture Model}
\usage{
\method{predict}{survival_ln_mixture}(
  object,
  new_data,
  type,
  eval_time,
  interval = "none",
  level = 0.95,
  ...
)
}
\arguments{
\item{object}{A \code{survival_ln_mixture} object.}

\item{new_data}{A data frame or matrix of new predictors.}

\item{type}{A single character. The type of predictions to generate.
Valid options are:
\itemize{
\item \code{"time"} for the survival time. \strong{not implmeented}
\item \code{"survival"} for the survival probability.
\item \code{"hazard"} for the hazard.
}}

\item{eval_time}{For type = "hazard" or type = "survival", the times for the distribution.}

\item{interval}{should interval estimates be added? Options are "none" and "credible".}

\item{level}{the tail area of the intervals. Default value is 0.95.}

\item{...}{Not used, but required for extensibility.}
}
\value{
A tibble of predictions. The number of rows in the tibble is guaranteed
to be the same as the number of rows in \code{new_data}.
}
\description{
Predict from a Lognormal Mixture Model
}
\note{
Categorical predictors must be converted to factors before the fit,
otherwise the predictions will fail.
}
\examples{

# Categorical variables must be converted to factor before the fit.

require(survival)
# Wrong way of doing
set.seed(1)
mod <- survival_ln_mixture(Surv(time, status == 2) ~ factor(sex), lung, intercept = TRUE)

\dontrun{
# this piece of code will throw error
predict(mod, data.frame(sex = 1), type = "survival", eval_time = 100)
}

# Correct way
lung$sex <- factor(lung$sex) # converting to factor before
set.seed(1)
mod2 <- survival_ln_mixture(Surv(time, status == 2) ~ sex, lung, intercept = TRUE)
# Note: the categorical predictors must be a character.
predict(mod2, data.frame(sex = "1"), type = "survival", eval_time = 100)

}
