\name{4.3.lims.and.scales.handlers}
\alias{4.3.lims.and.scales.handlers}
\alias{limsHandler}
\alias{localScalesHandler}
\alias{panel.localScale}
\alias{yscale.component.log10}
\alias{xscale.component.log10}


\title{
  Plot lims and scales handlers
}
\description{
  In development functions for lims and scales handling with lattice plots.
}
\usage{


limsHandler(x=NULL, y=NULL, z=NULL, ..., lim.borders = 0.05)

localScalesHandler(scales = NULL, ..., allowed.scales =c("x", "y"),  
         disallowed.scales = NULL, remove.box = FALSE)

panel.localScale(x.loc, y.loc, lim, ..., panel.scale = NULL, 
         label.before = TRUE, x.offset = NULL, y.offset = NULL, 
         axis = TRUE, ticks = TRUE, annotation = TRUE)

yscale.component.log10(...)

xscale.component.log10(...)

}


\arguments{

  \item{x, y, z}{\code{x}, \code{y} and/or \code{z} data series.
   }

  \item{lim.borders}{numeric vector, giving the relative border to 
   extend \code{...lim} ranges by when generating axes or scales. The 
   \code{lim.borders} are relative proportions. So, the default setting 
   of 0.05 adds an extra +/- 5\% to the data range. If multiple values 
   are supplied the first three are treated as \code{x}, \code{y} and 
   \code{z} lim.borders, respectively. If less than three values are 
   supplied, the three values are generated by wrapping. So, the default 
   setting of 0.05 is equivalent to c(0.05, 0.05, 0.05).
   }

  \item{scales, panel.scale}{ A list of elements like the \code{scales} 
   argument used with \code{lattice} functions. Current 
   default elements \code{draw (= TRUE)}, \code{arrows (= FALSE)}, 
   \code{tick.number (= 5)}, \code{abbreviate (= FALSE)}, 
   \code{minlength (= 4)}, and \code{tck (= 1)}.
   }

  \item{...}{ Additional arguments. 
   } 

 \item{allowed.scales}{ A character vector containing the names 
   of the axes to be generated for as part of a local axis.  
   } 

 \item{disallowed.scales}{ A character vector containing the names 
   of any axes that are not required. Note: If found, these are 
   removed from \code{scales} before evaluation.
   } 

 \item{remove.box}{ A logical, default \code{FALSE}. Should the 
   box \code{lattice} typically places around standard plots be 
   removed? This can be useful if you are using a \code{panel...} 
   function to generate axes within the plot.
   }
 
 \item{x.loc, y.loc, lim}{ two member vectors setting the \code{x} 
   and \code{y} locations where the scale is to be drawn (\code{x.loc} 
   ans \code{y.loc}), and the limits of the range to be annotated on the 
   scale (\code{lim}). Note: These are currently handled 'as is', i.e. 
   for both locations and limit, the first element is the start point 
   and the second is the end point, and any other elements are ignored.  
   }

 \item{label.before, x.offset, y.offset}{ Scale annotation overrides. 
   \code{label.before} is a logical, which controls the position of 
   annotation, tick marks and/or arrows, etc relative to the scale 
   line (i.e., above/left before or below/right after). By default 
   \code{panel.localScale} generates tick marks and labels at right 
   angles to the scale line/axis. \code{x.offset} and \code{y.offset} 
   force the offsets when adding tick marks and annotation.  
   }

  \item{axis,ticks,annotation}{If supplied, fine controls for the 
   appearance of the axis line, axis tick marks and axis annotation 
   on the generated scale. These can be vectors, in which they are 
   assumed to be color assignments, or lists of common plot parameters, 
   such as \code{col}, \code{lty}, \code{lwd}, etc.  
   }

} 


\details{
  \code{limsHander} generates \code{xlim}, \code{ylim} and/or \code{zlim} 
   ranges for axes or color scales for use in a range of plots. 

  \code{localScalesHandler} provides a relatively crude mechanism 
   for the removal of conventional \code{lattice} plot axes and 
   the generation of alternative axes using a \code{panel...} function 
   like \code{panel.localScale}. 

}

\value{

  \code{limsHandler} returns a list containing \code{...lim} ranges for 
   any of the elements \code{x}, \code{y} and/or \code{z} supplied to it. 

  \code{localScalesHandler} returns a list containing the 
   elements: \code{scales}, \code{panel.scales} and possibly 
   \code{par.settings}. \code{scales} turns off the standard 
   axes annotation. \code{panel.scales} is a list of named elements, one 
   per named axis, describing the axis layout. If 
   \code{remove.box = TRUE}, the additional argument \code{par.settings} 
   is also supplied. 

   All arguments should be passed on to the associated plot. 

   \code{panel.scales} or axis-specific elements in \code{panel.scales} 
   can then be evaluated by an associated \code{panel...} function run 
   from within the lattice plot call. This would typically 
   take the form: 

   \code{panel.my.axis(panel.scale = panel.scale$axis, ...)} 

   \code{panel.localScale} is a local axis/scale plotter. It can be used 
    in combination with \code{localScalesHandler}, and should called 
    once for each axis that is required, or it can be used 'stand alone' 
    panel to add a local scale to a lattice plot.

   \code{yscale.component.log10} and \code{xscale.component.log10} are 
   simple axis transforms for use with log to the base 10 transformed 
   plot axes.

}

\references{
  These function makes extensive use of code developed by others.  

  lattice:
  Sarkar, Deepayan (2008) Lattice: Multivariate Data
  Visualization with R. Springer, New York. ISBN
  978-0-387-75968-5
}

\author{
  Karl Ropkins
}

\note{
  \code{panel.localScale} is currently in revision. Scale arrows are 
  currently not available. 
}

\seealso{
   In other packages: \code{\link[lattice]{xyplot}} in \code{\link[lattice]{lattice}}.
}

\examples{

## See trianglePlot Example 2 for example application

}


\keyword{ methods }
