% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkSettings.R
\name{checkSettings}
\alias{checkSettings}
\title{Check the validity of a settings file or data.frame.}
\usage{
checkSettings(settings)
}
\arguments{
\item{settings}{Character or data.frame. Either the path to a settingsFile (csv)
or a data.frame containing settings.}
}
\value{
Logical, indicating whether all checks were passed or not.
}
\description{
Several checks are run:
\enumerate{
\item \code{settings} is either a valid file or a data.frame.
\item That the adjustments file is either an existing file or ""
\item That the channels file is either an existing file or NULL.
\item That the coordinates file exists.
\item That the detections file exists.
\item That the siteWavsFolder exists.
\item That buffer, margin, resolution, date, time, zMin, zMax and surveyLength
    can all be recognized as numbers.
\item That tempC or soundSpeed have been defined.
}
}
