% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getFilepaths.R
\name{getFilepaths}
\alias{getFilepaths}
\title{Get filepath information for a date and time.}
\usage{
getFilepaths(settings, types = "wav")
}
\arguments{
\item{settings}{Either a filepath to a settings file (csv) or a settings
list. If a filepath, the filepath will first be passed to
\code{\link{processSettings}}.}

\item{types}{Character, specifying the file type to be searched for. Either 'wav' or 'mp3'.}
}
\value{
A data frame with station names, coordinates, filepaths, and any
    recording start-time adjustments.
}
\description{
\code{getFilepaths} reads information from a settings file (csv) or a
settings list and returns the file paths and other information as a
dataframe. It undertakes a recursive search within the site folder for files
matching the date and time.
}
\examples{
    #Read example data
    settings <- read.csv(system.file('extdata',
                   'Ex_20200617_090000_Settings.csv', package = 'locaR'),
                   stringsAsFactors = FALSE)

    #Over-write default values for SiteWavsFolder, CoordinatesFile, and ChannelsFile
    settings$Value[settings$Setting == 'SiteWavsFolder'] <-
                  system.file('extdata', package = 'locaR')
    settings$Value[settings$Setting == 'CoordinatesFile'] <-
                   system.file('extdata', 'Vignette_Coordinates.csv',
                               package = 'locaR')
    settings$Value[settings$Setting == 'ChannelsFile'] <-
                   system.file('extdata', 'Vignette_Channels.csv',
                               package = 'locaR')

    #Run processSettings() function
    st <- processSettings(settings = settings, getFilepaths = FALSE)

    #Get filepaths.
    fp <- getFilepaths(settings = st, types = 'mp3')
}
