% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layoutMatrix.R
\name{layoutMatrix}
\alias{layoutMatrix}
\title{Specify the spatial layout of microphones.}
\usage{
layoutMatrix(
  st,
  stationNames = NULL,
  start = c("topleft", "topright", "bottomleft", "bottomright"),
  byrow = TRUE,
  nrow,
  ncol
)
}
\arguments{
\item{st}{List. Localization settings object generated using
\code{\link{processSettings}}.}

\item{stationNames}{Character vector. Vector of station names. Not required if st is provided.}

\item{start}{Character. When sorted alphabetically, the location of the first station name.}

\item{byrow}{Logical. An indicator of whether station names increase along
rows (TRUE) or along columns (FALSE)}

\item{nrow}{Numeric. The number of rows of microphones in the layout.}

\item{ncol}{Numeric. The number of columns of microphones in the layout.}
}
\value{
Matrix, containing the station names within the array. If done correctly,
    the matrix rows and columns should align with the spatial layout of the stations
    in the field.
}
\description{
\code{layoutMatrix} creates a matrix of station names, which correspond to
the layout of stations in space.This is passed to the \code{omniSpectro} function
for the purposes of generating spectrograms that align with the spatial
orientation of stations. The four user-specified arguments indicate where
the first station occurs (e.g. topleft means the first
station is in the northwest; the "first" station means the one with the name
that would appear first when sorted alphabetically). byrow means the stations
increase along rows (either left to right or right to left) and nrow and
ncol indicate how many rows and columns of microphones there are
(assuming the array has a rectangular shape).
Note that this layout function is provided for convenience, but users can easily
specify their own custom layouts manually.
}
\examples{

    #Vector of station names, Ex-1 to Ex-9.
    stationNames <- paste0('Ex-',1:9)

    #All options shown below.
    #layoutMatrix starting from top left (NW) to bottom right (SE) by row.
    layoutMatrix(stationNames = stationNames,
                 start = 'topleft', byrow = TRUE, ncol = 3, nrow = 3)

    #layoutMatrix starting from top left (NW) to bottom right (SE) by column.
    layoutMatrix(stationNames = stationNames,
                 start = 'topleft', byrow = FALSE, ncol = 3, nrow = 3)

    #layoutMatrix starting from top right (NE) to bottom left (SW) by row.
    layoutMatrix(stationNames = stationNames,
                 start = 'topright', byrow = TRUE, ncol = 3, nrow = 3)

    #layoutMatrix starting from top right (NE) to bottom left (SW) by column.
    layoutMatrix(stationNames = stationNames,
                 start = 'topright', byrow = FALSE, ncol = 3, nrow = 3)

    #layoutMatrix starting from bottom left (SW) to top right (NE) by row.
    layoutMatrix(stationNames = stationNames,
                 start = 'bottomleft', byrow = TRUE, ncol = 3, nrow = 3)

    #layoutMatrix starting from bottom left (SW) to top right (NE) by column.
    layoutMatrix(stationNames = stationNames,
                 start = 'bottomleft', byrow = FALSE, ncol = 3, nrow = 3)

    #layoutMatrix starting from bottom right (SE) to top left (NW) by row.
    layoutMatrix(stationNames = stationNames,
                 start = 'bottomright', byrow = TRUE, ncol = 3, nrow = 3)

    #layoutMatrix starting from bottom right (SE) to top left (NW) by column.
    layoutMatrix(stationNames = stationNames,
                 start = 'bottomright', byrow = FALSE, ncol = 3, nrow = 3)
}
