% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeSearchMap.R
\name{makeSearchMap}
\alias{makeSearchMap}
\title{Create a grid over which to search for sound sources.}
\usage{
makeSearchMap(
  easting,
  northing,
  elevation,
  margin = 10,
  zMin = -1,
  zMax = 10,
  resolution = 1
)
}
\arguments{
\item{easting}{vector of x coordinates of microphones.}

\item{northing}{vector of y coordinates of microphones.}

\item{elevation}{vector of z coordinates of microphones.}

\item{margin}{distance (in meters) to extend the search grid
beyond the x-y limits of the microphone locations. The same buffer is
applied to x and y coordinates.}

\item{zMin}{distance (in meters) to begin search relative to the microphone
with the lowest elevation. Typically a small negative number to ensure
that the grid search begins slightly below the lowest microphone.}

\item{zMax}{distance (in meters) to end search relative to the microphone
with the highest elevation. Typically a positive number to ensure
that the grid search ends well above the highest microphone.}

\item{resolution}{resolution of the search map, in meters.}
}
\value{
A list defining the search map.
}
\description{
\code{makeSearchMap} creates the three-dimensional array over which to search
for sound sources.
}
\details{
The localization algorithms used in this package can search for sound sources
over areas with arbitrary size and with arbitrary resolution. However, speed
can sometimes be slow. Generally speaking, the speed of localization
calculations correlates directly with the number of grid cells to be
searched. Speed can therefore be increased by searching a smaller area
(i.e. by reducing the margin, increasing zMin, or decreasing zMax),
or by searching with a coarser grain (i.e. by increasing the resolution).

The final list defining the search map includes three arrays containing
x, y and z coordinates of
each grid cell, as well as the resolution and range of values in the x,
y and z directions. This list is passed to other functions for localization.
}
\examples{
    #read coordinates.
    coords <- read.csv(system.file('extdata', 'Vignette_Coordinates.csv', package = 'locaR'),
       stringsAsFactors = FALSE)
    #make search map.
    sm <- makeSearchMap(easting = coords$Easting,
                       northing = coords$Northing,
                       elevation = coords$Elevation)
}
