% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loglevel.R
\name{loglevel}
\alias{loglevel}
\alias{is.loglevel}
\alias{as.loglevel}
\alias{print.loglevel}
\alias{as.numeric.loglevel}
\alias{as.character.loglevel}
\alias{available.loglevels}
\alias{verbosity}
\title{Logging levels}
\usage{
loglevel(i)

is.loglevel(x, ...)

as.loglevel(i)

\method{print}{loglevel}(x, ...)

\method{as.numeric}{loglevel}(x, ...)

\method{as.character}{loglevel}(x, ...)

available.loglevels()

verbosity(v)
}
\arguments{
\item{i}{An integer from the set 1..5.  Otherwise it will be modified
sensibly to fit in that range.  Alternatively, a named logging level
(one of "DEBUG", "INFO", "WARN", "ERROR", or "FATAL").}

\item{x}{An object of class "loglevel"}

\item{...}{Unused}

\item{v}{A verbosity level from the set 5..1. For historical reasons, they
do not match the log levels; a verbosity level of 1 corresponds to a
logging level of 5, 2 corresponds to 4, etc.}
}
\value{
An object of class "loglevel"
}
\description{
Functions for handling logging levels.  With each log entry, a logging level
is associated that indicate its severity -- debugging output, informational
output, warning message, error message or fatal error.  Each logger only
prints log entries where the log level is equal or above its threshold.
}
\details{
To specify a logging level, use a character value, e.g. \code{"WARN"}, or an
integer between 1 and 5. The function \code{available.levels} lists all possible
logging levels.
}
\examples{
loglevel(2) == loglevel("INFO")
loglevel("WARN") < loglevel("ERROR")
loglevel(-1)
try(loglevel("UNDEFINED"))
is.loglevel("DEBUG")
is.loglevel(loglevel("DEBUG"))
as.numeric(loglevel("FATAL"))
available.loglevels()

\dontrun{
library(optparse)
library(log4r)

optlist <- list(make_option(c('-v', '--verbosity-level'),
  type = "integer",
  dest = "verbosity",
  default = 1,
  help = "Verbosity threshold (5=DEBUG, 4=INFO 3=WARN, 2=ERROR, 1=FATAL)"))

optparser <- OptionParser(option_list=optlist)
opt <- parse_args(optparser)

my.logger <- create.logger(logfile = "", level = verbosity(opt$verbosity))

fatal(my.logger, "Fatal message")
error(my.logger, "Error message")
warn(my.logger, "Warning message")
info(my.logger, "Informational message")
debug(my.logger, "Debugging message")
}
}
