% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/traits_faxes_cor.R
\name{traits.faxes.cor}
\alias{traits.faxes.cor}
\title{Correlation between Traits and Axes}
\usage{
traits.faxes.cor(
  sp_tr,
  sp_faxes_coord,
  tr_nm = NULL,
  faxes_nm = NULL,
  plot = FALSE,
  name_file = NULL,
  color_signif = "darkblue",
  color_non_signif = "gray80",
  stop_if_NA = TRUE
)
}
\arguments{
\item{sp_tr}{a data frame containing species as rows and traits as columns.}

\item{sp_faxes_coord}{a matrix of species coordinates in a multidimensional
functional space. Species coordinates have been retrieved
thanks to \code{\link{tr.cont.fspace}} or \code{\link{quality.fspaces}}.}

\item{tr_nm}{a vector gathering the names of traits (as in \code{sp_tr}) to
consider. If \code{NULL} all traits are considered.}

\item{faxes_nm}{a vector gathering the names of PCoA axes (as in
\code{sp_faxes_coord}) to consider.}

\item{plot}{a logical value indicating whether plot illustrating relations
between trait and axes should be drawn. \strong{You can only plot relationships
for up to 10 traits and/or 10 axes}.}

\item{name_file}{the file name (without extension) to save the plot as a 300
dpi JPEG file. Default is \code{NULL} which means plot is only displayed. If
\code{plot = FALSE} this argument is ignored.}

\item{color_signif}{an R color name or an hexadecimal code referring to
the color of points when relationships between the trait and the axis is
significant. Default is \code{darkblue}.}

\item{color_non_signif}{an R color name or an hexadecimal code referring to
the
color of points when relationships between the trait and the axis are not
significant. Default is \code{gray80}.}

\item{stop_if_NA}{a logical value to stop or not the process if the
\code{sp_tr} data frame contains NA. Functional measures are sensitive to
missing traits. For further explanations, see the Note section.
Default is \code{TRUE}.}
}
\value{
1 data frame with for each combination of trait and axis (rows), the
name of the test performed, and the corresponding statistics and p-value.
If \code{plot = TRUE} a multi-panel figure with traits as columns and axes as
rows is also plotted. When relationships between trait and axis is
significant the points are colored, else they remain grayish.
}
\description{
Compute relationship between all traits and all axes of the functional
space. For continuous trait a linear model is computed and r2 and p-value
are returned. For other types of traits, a Kruskal-Wallis test is computed
and eta2 statistics is returned.
Option allows to plot trait-axis relationships with scatterplot and boxplot
for continuous and non-continuous traits, respectively.
}
\examples{
# Load Species x Traits Data
data("fruits_traits", package = "mFD")

# Load Traits categories dataframe
data("fruits_traits_cat", package = "mFD")

# Compute Functional Distance
sp_dist_fruits <- mFD::funct.dist(sp_tr  = fruits_traits,
 tr_cat = fruits_traits_cat,
 metric = "gower",
 scale_euclid  = "scale_center",
 ordinal_var = "classic",
 weight_type = "equal",
 stop_if_NA  = TRUE)
  
# Compute Functional Spaces Quality (to retrieve species coordinates)
fspaces_quality_fruits <- mFD::quality.fspaces(
  sp_dist             = sp_dist_fruits, 
  maxdim_pcoa         = 10,
  deviation_weighting = "absolute",
  fdist_scaling       = FALSE,
  fdendro             = "average")
  
# Retrieve Species Coordinates
sp_faxes_coord_fruits <- fspaces_quality_fruits$details_fspaces$sp_pc_coord

# Compute Correlation between Traits and Functional Axes
mFD::traits.faxes.cor(
  sp_tr          = fruits_traits, 
  sp_faxes_coord = sp_faxes_coord_fruits, 
  tr_nm          = NULL, 
  faxes_nm       = NULL,
  name_file      = NULL, 
  color_signif   = "darkblue",
  color_non_signif = "gray80")
}
\author{
Nicolas Loiseau and Sebastien Villeger
}
