% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04-catalogue_functions.R
\name{valueType_of}
\alias{valueType_of}
\title{Return the valueType of an object}
\usage{
valueType_of(x)
}
\arguments{
\item{x}{Object. Can be a vector.}
}
\value{
A character string which is the valueType of the input object.
}
\description{
Determines the valueType of an object based on \code{\link[=typeof]{typeof()}} and
\code{\link[=class]{class()}}. The possible values returned are 'date', 'datetime', 'boolean',
'integer', 'decimal', and 'text'.
}
\details{
The valueType is a declared property of a variable that is required in
certain functions to determine handling of the variables. Specifically,
valueType refers to the
\href{https://opaldoc.obiba.org/en/dev/variables-data.html#value-types}{OBiBa data type of a variable}.
The valueType is specified in a data dictionary in a column 'valueType' and
can be associated with variables as attributes. Acceptable valueTypes
include 'text', 'integer', 'decimal', 'boolean', datetime', 'date'. The full
list of OBiBa valueType possibilities and their correspondence with R data
types are available using \link{valueType_list}. The valueType can be used to
coerce the variable to the corresponding data type.
}
\examples{
{

# use madshapR_examples provided by the package
dataset <- madshapR_examples$`dataset_example`
valueType_of(dataset[['part_id']])

# any data frame can be dataset by definition
valueType_of(iris[['Sepal.Length']])

}

}
\seealso{
\code{\link[=typeof]{typeof()}}, \code{\link[=class]{class()}}
\href{https://opaldoc.obiba.org/en/dev/magma-user-guide/value/type.html}{Opal documentation}
}
