% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workflow_functions.R
\name{batch_analysis_enhanced}
\alias{batch_analysis_enhanced}
\title{Enhanced Batch Analysis with Full Visualizations}
\usage{
batch_analysis_enhanced(
  years,
  scale = "huc8",
  nutrients = c("nitrogen", "phosphorus"),
  include_wwtp = TRUE,
  output_base_dir = tempdir(),
  create_all_visualizations = TRUE,
  create_comparative_plots = TRUE,
  show_progress = TRUE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{years}{Numeric vector. Years to analyze}

\item{scale}{Character. Spatial scale}

\item{nutrients}{Character vector. Nutrients to analyze}

\item{include_wwtp}{Logical. Include WWTP analysis}

\item{output_base_dir}{Character. Base output directory}

\item{create_all_visualizations}{Logical. Create all maps, networks, and comparisons}

\item{create_comparative_plots}{Logical. Create year-over-year comparisons}

\item{show_progress}{Logical. Display progress bar (requires 'progress' package)}

\item{verbose}{Logical. Show progress}

\item{...}{Additional arguments}
}
\value{
List of results with comprehensive outputs
}
\description{
Run batch analysis with comprehensive visualization output for each year
}
\examples{
\dontrun{
# This function is computationally intensive
# See vignette("advanced-features") for examples
results <- batch_analysis_enhanced(years = 2015:2016)
}
}
