% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autodiff.R
\name{autodiff}
\alias{autodiff}
\title{EXPERIMENTAL -- Enable Automatic Differentiation with JAX}
\usage{
autodiff(autodiff = NULL, install = FALSE)
}
\arguments{
\item{autodiff}{Logical flag. If \code{TRUE}, enables automatic differentiation
with JAX. If \code{FALSE} (default), disables automatic differentiation and
reverts to finite difference methods.}

\item{install}{Logical flag. If \code{TRUE}, installs the \code{marginaleffectsAD}
Python package via \code{reticulate::py_install()}. Default is \code{FALSE}. This is
only necessary if you are self-managing a Python installation.}
}
\value{
No return value. Called for side effects of enabling/disabling
automatic differentiation.
}
\description{
This function enables or disables automatic differentiation using the JAX
package in Python, which can considerably speed up and increase the accuracy
of standard errors when a model includes many parameters.
}
\details{
When \code{autodiff = TRUE}, this function:
\itemize{
\item Imports the \code{marginaleffectsAD} Python package via \code{\link[reticulate:py_install]{reticulate::py_install()}}
\item Sets the internal jacobian function to use JAX-based automatic differentiation
\item Provides faster and more accurate gradient computation for supported models
\item Falls back on the default finite difference method for unsupported models and calls.
}

Currently supports:
\itemize{
\item Model types: \code{lm}, \code{glm}, \code{ols}, \code{lrm}
\item Functions: \code{\link[=predictions]{predictions()}} and \code{\link[=comparisons]{comparisons()}}, along with \code{avg_} and \code{plot_} variants.
\item \code{type}: "response" or "link"
\item \code{by}: \code{TRUE}, \code{FALSE}, or character vector.
\item \code{comparison}: "difference" and "ratio"
}

For unsupported models or options, the function automatically falls back to
finite difference methods with a warning.
}
\section{Python Configuration}{
By default, no manual configuration of Python should be necessary. On most
machines, unless you have explicitly configured \code{reticulate}, reticulate
defaults to an automatically managed ephemeral virtual environment with all
Python requirements declared via \code{reticulate::py_require()}.

If you prefer to use a manually managed Python installation, you can direct
\code{reticulate} and specify which Python executable or environment to use.
\code{reticulate} selects a Python installation using its \href{https://rstudio.github.io/reticulate/articles/versions.html#order-of-discovery}{Order of Discovery}.
As a convenience \code{autodiff(install=TRUE)} will install \code{marginaleffectsAD} in
a self-managed virtual environment.

To specify an alternate Python version:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(reticulate)
use_python("/usr/local/bin/python")
}\if{html}{\out{</div>}}

To use a virtual environment:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{use_virtualenv("myenv")
}\if{html}{\out{</div>}}

These configuration commands should be called before calling \code{autodiff()}.
}

\examples{
\dontrun{
# Install the Python package (only needed once)
autodiff(install = TRUE)

# Enable automatic differentiation
autodiff(TRUE)

# Fit a model and compute marginal effects
mod <- glm(am ~ hp + wt, data = mtcars, family = binomial)
avg_comparisons(mod) # Will use JAX for faster computation

# Disable automatic differentiation
autodiff(FALSE)
}

}
