% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/markov_mix.R
\name{predict.MarkovMix}
\alias{predict.MarkovMix}
\title{Predict probabilities with MarkovMix object and new sequence list}
\usage{
\method{predict}{MarkovMix}(object, newdata, aggregate. = TRUE, ...)
}
\arguments{
\item{object}{\code{\link{MarkovMix}} object.}

\item{newdata}{Sequence list containing vectors of the same class.}

\item{aggregate.}{Logical (1L) indicating whether probabilities
from each component should be weighted mean by component priors
(\code{TRUE}) or not (\code{FALSE}).}

\item{...}{Currently ignored for this method.}
}
\value{
For \code{aggregate. = TRUE}, a numeric vector of probabilities.
For \code{aggregate. = TRUE}, a numeric matrix of probabilities
from each component.
}
\description{
\code{predict.MarkovMix} predicts probabilities with \code{\link{MarkovMix}} object
and new sequence list. NA values are returned for sequences with no valid sub-sequences
to distinguish them from those that are truly not observed (probabilities = 0)
in the transition matrices.
}
\note{
Change log:
\itemize{
\item{0.1.0 Xiurui Zhu - Initiate the function.}
}
}
\examples{
# Load example MarkovMix object
data("markov_mix_ex")

# Generate a new list of sequences
set.seed(2222L)
new_maxlen <- 8L
new_seq_list <- purrr::map(
  seq_len(50L),
  ~ sample(get_states(object = markov_mix_ex, check = FALSE),
           sample.int(new_maxlen, 1L),
           replace = TRUE)
)

# Predict the probabilities of sequences
predict(markov_mix_ex, newdata = new_seq_list)

# Predict the probabilities of sequences from each component
predict(markov_mix_ex, newdata = new_seq_list, aggregate. = FALSE)
}
\seealso{
Other MarkovMix methods: 
\code{\link{print.MarkovMix}()}
}
\author{
Xiurui Zhu
}
\concept{MarkovMix methods}
