% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate_grid_to_polygons.R
\name{aggregate_raster_to_polygons_validation}
\alias{aggregate_raster_to_polygons_validation}
\title{Aggregate a raster to polygons: validation}
\usage{
aggregate_raster_to_polygons_validation(
  data_raster,
  aggregation_table,
  aggregation_cols,
  method,
  aggregated_field,
  z_dimension,
  z_dimension_name,
  weighting_raster,
  na.rm
)
}
\arguments{
\item{data_raster}{\link[terra:SpatRaster-class]{terra::SpatRaster} containing data to be aggregated to polygons.}

\item{aggregation_table}{Aggregation table linking pixels to polygon identifiers,
created using \code{build_aggregation_table()}}

\item{aggregation_cols}{(character vector, default 'polygon_id') Polygon identifiers
to use for aggregation.}

\item{method}{(character, default 'mean') Aggregation method: one of 'mean', 'sum',
'weighted.mean', or 'weighted.sum'.}

\item{aggregated_field}{(character, default 'data') Name of the aggregated raster
values in the output table.}

\item{z_dimension}{(vector, default NULL) If passing a \code{data_raster} with multiple
layers, how should each layer be identified?}

\item{z_dimension_name}{(default 'z') The field name for the "z" dimension
corresponding to each layer of the \code{data_raster}.}

\item{weighting_raster}{(\link[terra:SpatRaster-class]{terra::SpatRaster}, default NULL) The relative weighting of
each whole pixel to the overall polygon value, for example, if calculating a
population-weighted mean.}

\item{na.rm}{(bool, default TRUE) How to handle NA pixels in \code{data_raster} and
\code{weighting_raster}.}
}
\value{
Errors if checks fail; silently passes if checks pass
}
\description{
Data validation for aggregate_raster_to_polygons
}
\seealso{
aggregate_raster_to_polygons
}
\keyword{internal}
