% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priors.R
\name{pr_invchisq}
\alias{pr_invchisq}
\title{Create an object representing inverse chi-squared priors
with possibly modelled degrees of freedom and scale parameters}
\usage{
pr_invchisq(df = 1, scale = 1)
}
\arguments{
\item{df}{degrees of freedom parameter. This can be a numeric scalar or
vector of length \code{n}, the dimension of the parameter vector.
Alternatively, for a scalar degrees of freedom parameter,
\code{df="modeled"} or \code{df="modelled"} assign a default (gamma) prior
to the degrees of freedom parameter. For more control of this gamma prior a
list can be passed with some of the following components:
\describe{
  \item{alpha0}{shape parameter of the gamma distribution}
  \item{beta0}{rate parameter of the gamma distribution}
  \item{proposal}{"RW" for random walk Metropolis-Hastings
    or "mala" for Metropolis-adjusted Langevin}
  \item{tau}{(starting) scale of Metropolis-Hastings update}
  \item{adapt}{whether to adapt the scale of the proposal distribution
    during burnin to achieve better acceptance rates.}
 }}

\item{scale}{scalar or vector scale parameter. Alternatively,
\code{scale="modeled"} or \code{scale="modelled"} puts a default
chi-squared prior on the scale parameter. For more control on this
chi-squared prior a list can be passed with some of the following components:
\describe{
  \item{df}{degrees of freedom (scalar or vector)}
  \item{scale}{scale (scalar or vector)}
  \item{common}{whether the modelled scale parameter of the inverse chi-squared
    distribution is (a scalar parameter) common to all \code{n} parameters.}
}}
}
\value{
An environment representing the specified prior, for internal use.
}
\description{
Create an object representing inverse chi-squared priors
with possibly modelled degrees of freedom and scale parameters
}
