% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expect_invariant.R
\name{expect_mcmc}
\alias{expect_mcmc}
\title{Test of MCMC chain}
\usage{
expect_mcmc(object, control = NULL, thinning = NULL, joint = FALSE)
}
\arguments{
\item{object}{A list describing the MCMC sampler with the following elements:
\itemize{
\item genprior: A function with no arguments that generates a sample of the prior distribution. No default value.
\item gendata: A function that takes as input the parameter value (of the type generated by genprior) and returns the observed data as an arbitrary R object. No default value.
\item stepMCMC: A function that takes three arguments:
\itemize{
\item theta: the current position of the chain (of the same type as produced by the prior),
\item dat: the observed data (of the same type as produced by gendat)
\item thinning: the number of steps the chain should take. 1 corresponds to one step.
}
\item test: Function that takes either one or two arguments, and returns a vector with components which will be used for checking the MCMC sampler. The first argument is interpreted as a parameter value, and if a second argument exists, it is interpreted as a data value. An example is the identity function: function(x) x. Alternatively, if you have access to the model's likelihood function, you could use: function(x,y) likelihood(x,y).
}}

\item{control}{a list controlling the algorithm
\itemize{
\item n number of samples to be taken in the first step. Default: 1e3
\item maxseqsteps: Number of sequential attempts to use. Default: 7.
\item incn: Factor by which to multiply n from the second  sequential attempt onward. Default: 4.
\item level: bound on the type I error, ie the probability of wrongly rejecting a sampler with the correct distribution. Default: 1e-5.
\item debug: If positive  then debug information will be printed via 'message()'. Default: 0.
}}

\item{thinning}{Amount of thinning for the MCMC chain. 1 corresponds to no thinning. Default: automatically computed to ensure an autocorrelation of at most 0.5 at lag 1.}

\item{joint}{If TRUE, then the MCMC uses systematic scan of both data and parameters, rather than just updating parameters with the sampler to be tested. Default: FALSE.}
}
\value{
The first argument, invisibly, to allow chaining of expectations.
}
\description{
Test of MCMC steps having the correct stationary distribution
without assuming reversibility of the chain. Details of this are in
\insertCite{gandy_scott_2019;textual}{mcunit}; it uses ideas
described in the appendix of
\insertCite{gandy_veraart_2017;textual}{mcunit}.
}
\examples{
object <- list(genprior=function() rnorm(1),
               gendata=function(theta) rnorm(5,theta),
               stepMCMC=function(theta,data,thinning){
                  f <- function(x) prod(dnorm(data,x))*dnorm(x)  
                  for (i in 1:thinning){
                     thetanew = rnorm(1,mean=theta,sd=1)
                     if (runif(1)<f(thetanew)/f(theta))
                     theta <- thetanew
                  }
                  theta
               }
               )
expect_mcmc(object)
}
\references{
\insertAllCited{}
}
\seealso{
\link{expect_mcmc_reversible}
}
