% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/string_occurs.R
\name{string_occurs}
\alias{string_occurs}
\title{Find Strings in Text}
\usage{
string_occurs(dict_list, haystack, ignore.case = TRUE, nClust = 2)
}
\arguments{
\item{dict_list}{character vector; value(s) to find}

\item{haystack}{character vector; phrase(s) where values may exist}

\item{ignore.case}{logical; indicates if spelling case matters, defaulting to \sQuote{TRUE}}

\item{nClust}{Number of CPU cores to use, if available. This requires the \sQuote{parallel}
package.}
}
\value{
list with two elements, \sQuote{TRUE} and \sQuote{FALSE}, representing values
that are found or not found within the phrase to search.
}
\description{
This function searches for text within one or more phrases. Text to look for will be grouped
into values that are found and not found.
}
\examples{
note1 <- "I am the very model of a modern major general
I've information vegetable, animal, and mineral
I know the kings of England, and I quote the fights historical
From marathon to Waterloo in order categorical;
I'm very well acquainted, too, with matters mathematical,
I understand equations both the simple and quadratical
About binomial theorem I'm teeming with a lot o' news,
With many cheerful facts about the square of the hypotenuse"
note2 <- "The quick brown fox jumps over the lazy dog"
string_occurs(c('kings','quick','couth','brown'), c(note1, note2))
}
