% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_story_list.R
\name{get_story_list}
\alias{get_story_list}
\title{Get story list}
\usage{
get_story_list(last_process_stories_id = 0L, rows = 100,
  feeds_id = NULL, q = NULL, fq = NULL,
  sort = "processed_stories_id", wc = FALSE, show_feeds = FALSE,
  api_key = Sys.getenv("MEDIACLOUD_API_KEY"))
}
\arguments{
\item{last_process_stories_id}{Return stories in which the
processed_stories_id is greater than this
value.}

\item{rows}{Number of stories to return, max 1000.}

\item{feeds_id}{Return only stories that match the given feeds_id, sorted
my descending publish date}

\item{q}{If specified, return only results that match the given Solr query.
Only one q parameter may be included.}

\item{fq}{If specified, file results by the given Solr query. More than one
fq parameter may be included.}

\item{sort}{Returned results sort order. Supported values:
processed_stories_id, random}

\item{wc}{If set to TRUE, include a 'word_count' field with each story that
includes a count of the most common words in the story}

\item{show_feeds}{If set to TRUE, include a 'feeds' field with a list of the
feeds associated with this story}

\item{api_key}{Character string with the API key you get from mediacloud.org.
Passing it is compulsory. Alternatively, function can be
provided from the global environment.}
}
\value{
Data frame with results. See \url{https://github.com/berkmancenter/mediacloud/blob/master/doc/api_2_0_spec/api_2_0_spec.md#stories} for field descriptions.
}
\description{
\code{get_story} returns a list of stories based on a multifaceted query. One
story represents one online publication. Each story refers to a single URL
from any feed within a single media source.
}
\examples{
\dontrun{
 stories <- get_story_list()
 stories <- get_story_list(q = "Trump")
}

}
