% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_sequence.R
\name{convert_sequence}
\alias{convert_sequence}
\alias{seq.mdate}
\title{Sequence method for messydates}
\usage{
\method{seq}{mdate}(from, to, by = "days", ...)
}
\arguments{
\item{from}{A messydate or range.
If 'from' is a range and 'to' is not specified,
'from' will be the minimum of the range and 'to' will be maximum.}

\item{to}{A messydate.}

\item{by}{Increment of the sequence. By default "days".}

\item{...}{Arguments passed to or from methods.}
}
\description{
This function provides a sequence (\code{seq()}) method for messydates.
This can be used with ranges or unspecified dates,
and is particularly useful for defining a sequence of dates
before the common era or between eras.
}
\examples{
seq(mdate("-0001-12-20"), mdate("0001-01-10"))
}
