% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metapred.R
\name{subset.metapred}
\alias{subset.metapred}
\title{Subsetting metapred fits}
\usage{
\method{subset}{metapred}(
  x,
  select = "cv",
  step = NULL,
  model = NULL,
  stratum = NULL,
  add = TRUE,
  ...
)
}
\arguments{
\item{x}{metapred object}

\item{select}{Which type of model to select: "cv" (default), "global", or (experimental) "stratified", 
or "stratum".}

\item{step}{Which step should be selected? Defaults to the best step. 
numeric is converted to name of the step: 0 for an unchanged model, 1 for the first change...}

\item{model}{Which model change should be selected? NULL (default, best change) or character name of variable
or (integer) index of model change.}

\item{stratum}{Experimental. Stratum to return if select = "stratum".}

\item{add}{Logical. Add data, options and functions to the resulting object? Defaults to \code{TRUE}. 
Experimental.}

\item{...}{For compatibility only.}
}
\value{
An object of class \code{mp.cv} for select = "cv" and an object of class \code{mp.global} for select = "global". 
In both cases, additional data is added to the resulting object, thereby making it suitable for further methods.
}
\description{
Return a model from the cross-validation procedure or the final 'global' model. Caution: This function is 
still under development.
}
\examples{
data(DVTipd)
DVTipd$cluster <- letters[1:4] # Add a fictional clustering to the data.
mp <- metapred(DVTipd, strata = "cluster", formula = dvt ~ histdvt + ddimdich, family = binomial)
subset(mp) # best cross-validated model
subset(mp, select = "global") # Final model fitted on all strata.
subset(mp, step = 1) # The best model of step 1
subset(mp, step = 1, model = "histdvt") # The model in which histdvt was removed, in step 1.

}
\author{
Valentijn de Jong
}
