% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metanet_pipe.R
\name{metanet_pipe}
\alias{metanet_pipe}
\alias{metanet_pipe.metanetwork}
\title{Execute 'metanetwork' pipeline}
\usage{
metanet_pipe(metanetwork, beta = 0.1, verbose = TRUE)

\method{metanet_pipe}{metanetwork}(metanetwork, beta = 0.1, verbose = TRUE)
}
\arguments{
\item{metanetwork}{object of class 'metanetwork'}

\item{beta}{the diffusion parameter of the diffusion kernel, a positive scalar controlling the
squeezing of the network}

\item{verbose}{a boolean indicating whether message along the pipeline should be printed}
}
\value{
object of class 'metanetwork', with computed trophic levels and layout stored as node attribute

\code{NULL}
}
\description{
Method executing the whole metanetwork pipeline for the initial metanetwork object (\code{append_agg_nets}, \code{compute_TL},
\code{attach_layout})
}
\examples{
library(metanetwork)
library(igraph)

g = make_lattice(dimvector = c(4,4),2,3,directed = TRUE)
meta0 = build_metanet(g)
meta0 = metanet_pipe(meta0)
ggmetanet(meta0)

}
