% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build.R
\name{build_from_derived}
\alias{build_from_derived}
\title{Build a dataset from derived}
\usage{
build_from_derived(
  metacore,
  ds_list,
  dataset_name = deprecated(),
  predecessor_only = TRUE,
  keep = FALSE
)
}
\arguments{
\item{metacore}{metacore object that contains the specifications for the
dataset of interest.}

\item{ds_list}{Named list of datasets that are needed to build the from. If
the list is unnamed,then it will use the names of the objects.}

\item{dataset_name}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Optional string to
specify the dataset that is being built. This is only needed if the metacore
object provided hasn't already been subsetted.\cr
Note: Deprecated in version 0.2.0. The \code{dataset_name} argument will be removed
in a future release. Please use \code{metacore::select_dataset} to subset the
\code{metacore} object to obtain metadata for a single dataset.}

\item{predecessor_only}{By default \code{TRUE}, so only variables with the origin
of 'Predecessor' will be used. If \code{FALSE} any derivation matching the
dataset.variable will be used.}

\item{keep}{String to determine which columns from the original datasets
should be kept
\itemize{
\item "FALSE" (default):  only columns that are also present in the ADaM
specification are kept in the output.
\item "ALL":              all original columns are carried through to the
ADaM, including those that have been renamed.
e.g. if DM.ARM is a predecessor to DM.TRT01P,
both ARM and TRT01P will be present as columns
in the ADaM output.
\item "PREREQUISITE":     columns are retained if they are required for future
derivations in the specification. Additional
prerequisite columns are identified as columns
that appear in the 'derivation' column of the
metacore object in the format "DATASET.VARIABLE",
but not as direct predecessors. Predecessors are
defined as columns where the derivation is a 1:1
copy of a column in a source dataset.
e.g. derivation = "VS.VSTESTCD" is a predecessor,
while derivation = "Value of VS.VSSTRESN where
VS.VSTESTCD == 'Heart Rate'" contains both
VS.VSTESTCD and VS.VSSTRESN as prerequisites, and
these columns will be kept through to the ADaM.
}}
}
\value{
dataset
}
\description{
This function builds a dataset out of the columns that just need to be pulled
through. So any variable that has a derivation in the format of
'dataset.variable' will be pulled through to create the new dataset. When
there are multiple datasets present, they will be joined by the shared
\code{key_seq} variables. These columns are often called 'Predecessors' in ADaM,
but this is not universal so that is optional to specify.
}
\examples{
library(metacore)
library(haven)
library(magrittr)
load(metacore_example("pilot_ADaM.rda"))
spec <- metacore \%>\% select_dataset("ADSL")
ds_list <- list(DM = read_xpt(metatools_example("dm.xpt")))
build_from_derived(spec, ds_list, predecessor_only = FALSE)
}
