% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmcolwl.R
\name{gm.col_wl}
\alias{gm.col_wl}
\title{Bar Graphic with Legend Model}
\usage{
gm.col_wl(
  data,
  ncolx,
  ncoly,
  ntimes,
  title,
  legtitle,
  xlab = NULL,
  ylab = NULL,
  div100 = FALSE,
  percent = FALSE,
  fontsize = 0,
  colors = grDevices::rainbow(n = ntimes, v = 0.7),
  clines = "white",
  ctext = "white",
  cbackground = "#141414",
  cbserie = cbackground,
  legwpos = 0,
  legheight = 0.5
)
}
\arguments{
\item{data}{a dataframe}

\item{ncolx}{number of x column in data frame}

\item{ncoly}{number of y column in data frame}

\item{ntimes}{number of observations to plot (count by tail)}

\item{title}{title of plot}

\item{legtitle}{title of legendbox}

\item{xlab}{x axis label}

\item{ylab}{y axis label}

\item{div100}{If data percent are not in decimal format set TRUE.}

\item{percent}{If TRUE, y axis in percent (default=F)}

\item{fontsize}{change size of all words in graphic (only numbers)}

\item{colors}{colors of bars}

\item{clines}{color of lines in graphic}

\item{ctext}{color of words in graphic}

\item{cbackground}{color of graphic background}

\item{cbserie}{color of serie border (default= same cbackground)}

\item{legwpos}{legend words position (numeric)}

\item{legheight}{height of legend box}
}
\value{
Return a graphic.
}
\description{
gm.col_wl make a bar plot. Graphic models function family do graphic creation
easy, is recommended for new programers, they have less and easyful parameters then p.col_ord but
the graphic customize is more limited.
}
\examples{
v=data.frame("x"=seq(from=1,to=4,by=1),"y"=c(5,3,7,2))

gm.col_wl(v,1,2,title="Simple example",ntimes=3,legwpos=-2.5)

}
