% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quickPlot2.R
\name{quickPlot2}
\alias{quickPlot2}
\title{Generic plotting showing results of microPop
Now shows resources and microbes on one plot.}
\usage{
quickPlot2(
  soln,
  numR,
  numStrains,
  microbeNames,
  yLabel = "Concentration (g/L)",
  xLabel = "Time",
  sumOverStrains = TRUE,
  resourceLegendPosition = "topleft",
  microbeLegendPosition = "topleft",
  saveFig = FALSE,
  figType = "eps",
  figName = "microPopFig",
  cex.plot = 1,
  cex.legend = 0.7
)
}
\arguments{
\item{soln}{ODE output from microPopModel() i.e. matrix out$solution}

\item{numR}{Scalar. Number of resources}

\item{numStrains}{Scalar. Number of strains per group}

\item{microbeNames}{Vector of strings which contains the names of the microbial groups in the system e.g. c('Bacteroides','Acetogens')}

\item{yLabel}{String for y axis label. Default is "Concentration (g/L)"}

\item{xLabel}{String for x axis label. Default is "Time"}

\item{sumOverStrains}{Logical. Default=TRUE}

\item{resourceLegendPosition}{String. Position of legend in resource plot, default is 'topleft'}

\item{microbeLegendPosition}{String. Position of legend in microbe plot, default is 'topleft'}

\item{saveFig}{Logical. Default is FALSE}

\item{figType}{String. Default is "eps"}

\item{figName}{String. Default is "microPopFig"}

\item{cex.plot}{Multiplier for text size on axes text. Default is 1}

\item{cex.legend}{Multiplier for text size in legend. Default is 0.7}
}
\value{
Nothing just generates a plot
}
\description{
Generic plotting showing results of microPop
Now shows resources and microbes on one plot.
}
