% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_required.R
\name{select_required}
\alias{select_required}
\title{Select required midfieldr variables}
\usage{
select_required(midfield_x, ..., select_add = NULL)
}
\arguments{
\item{midfield_x}{Data frame from which columns are selected, typically
\code{student}, \code{term}, \code{degree} or their subsets.}

\item{...}{Not used for passing values; forces subsequent arguments to be
referable only by name.}

\item{select_add}{Character vector of column names to be added (optionally)
to the default
\code{c("mcid", "institution", "race", "sex", "^term", "cip6", "level")}.}
}
\value{
A data frame in \code{data.table} format with the
following properties: rows are preserved; columns with names that
match or partially match values in \code{select_add} are retained; grouping
structures are not preserved.
}
\description{
Subset a data frame, selecting columns by matching or partially matching a
vector of character strings. A convenience function to reduce the dimensions
of a MIDFIELD data table at the start of a session by selecting only those
columns typically required by other midfieldr functions. Particularly useful
in interactive sessions when viewing the data tables at various stages of an
analysis.
}
\details{
Several midfieldr functions are designed to operate on one or more of the
MIDFIELD data tables, usually \code{student}, \code{term}, or \code{degree.} This family of
functions requires only a small subset of available variables: the required
columns built in to the function are \code{mcid}, \code{institution}, \code{race}, \code{sex},
\verb{^term}, \code{cip6}, and \code{level}. Additional column names or partial names can be
included by using the \code{select_add} argument.

The column names of \code{midfield_x} are searched for matches or partial matches
using \code{grep()}, thus search terms can include regular expressions. Variables
with names that match or partially match the search terms are returned; all
other columns are dropped. Rows are unaffected. Search terms not present are
silently ignored.

One could use this function to select columns from a non-MIDFIELD data frame,
but with no benefit to the user---conventional column selection syntax is
better suited to that task. Here, we specialize the column selection to serve
midfieldr functions.
}
\examples{
# Default character vector for selecting columns
default_cols<- c("mcid", "institution", "race", "sex", "^term", "cip6", "level")

# Create one string separated by OR
search_pattern <- paste(default_cols, collapse = "|")

# Find names of columns matching or partially matching 
x <- select_required(toy_student) 
names(x)
grepl(search_pattern, names(x))

x <- select_required(toy_term) 
names(x)
grepl(search_pattern, names(x))

x <- select_required(toy_degree) 
names(x)
grepl(search_pattern, names(x))

x <- select_required(toy_course) 
names(x)
grepl(search_pattern, names(x))

# Adding search terms
x <- select_required(toy_course, select_add = c("abbrev", "number", "grade")) 
names(x)



}
\concept{select_*}
