% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_from_reads.R
\name{search_from_reads}
\alias{search_from_reads}
\title{\code{search_from_reads}}
\usage{
search_from_reads(
  all_reads,
  search_tables,
  progress = TRUE,
  ID = "S1",
  all_qualities = NULL,
  output_temp_result = TRUE,
  temp_result_folder = "./temp_results",
  output_read_length = TRUE,
  bp = MulticoreParam()
)
}
\arguments{
\item{all_reads}{The reads containing the runs to search from}

\item{search_tables}{a dataframe with the following columns:
- ["id"],"type",["sequence"],"strand","result","extra","match_ref_seq"}

\item{progress}{whether to show the progress bar}

\item{ID}{the ID to use, default to S1}

\item{all_qualities}{quality data, default to NULL}

\item{output_temp_result}{whether to output the temporary results}

\item{temp_result_folder}{directory to output the temporary results}

\item{output_read_length}{whether to output the read length, NULL - do not output; csv - output to csv file; data - output to result}

\item{bp}{BiocParallel backend to use for parallelization}
}
\value{
will return a list of dataframe containing: -
`search_id`, `sequence`, `reads`, `raw_match`, `mean_qualities`, `indexes`.
}
\description{
\code{search_from_reads} identify the matches
from a list of search strings
}
