#' Gets matrices of medians for each individual sample for all measured parameters for all clusters
#'
#' @param citrus.combinedFCSSet loaded from citrusClustering.RData file generated by Citrus run
#' @param citrus.foldClustering loaded from citrusClustering.RData file generated by Citrus run
#' @param citrus.foldFeatureSet computed from first two variables using citrus.calculateFoldFeatureSet function from citrus package
#' @param groupsizes list of sizeso f the groups run in Citrus, in order of the selection for citrus run
#' @param meds The names of the columns from citrus.combinedFCSSet$data of interest to extract medians for
#'
#' @return Returns a list of matrices with columns corresponding to selected features and rows corresponding to sample groups;
#' each list element corresponds to data for a different cluster
#'
#' @examples
#' library(mineCitrus)
#' data("citrus.combinedFCSSet")
#' data("citrus.foldClustering")
#' data("citrus.foldFeatureSet")
#' meds<-allmeds(citrus.combinedFCSSet=citrus.combinedFCSSet,
#'               citrus.foldClustering=citrus.foldClustering,
#'               citrus.foldFeatureSet=citrus.foldFeatureSet)
#' medians<-classclustermeds(citrus.foldFeatureSet,citrus.foldClustering,
#'                           citrus.combinedFCSSet,groupsizes=c(10,10),meds=meds)
#'
#' @export
classclustermeds<-function(citrus.foldFeatureSet,citrus.foldClustering,citrus.combinedFCSSet,groupsizes,meds){
  cutoffs<-cumsum(groupsizes)
  cutoffs<-c(0,cutoffs)
  if(is.null(meds)){
    signals<-allmeds(citrus.combinedFCSSet = citrus.combinedFCSSet,citrus.foldClustering = citrus.foldClustering,citrus.foldFeatureSet = citrus.foldFeatureSet)
  }else{
    signals<-meds
  }
  data<-citrus.combinedFCSSet$data
  parnames<-colnames(signals[[1]])
  ind<-grep("fileId",parnames)
  group<-list()
  ameds<-list()
  count<-1
  for(j in signals){
    for(i in 2:length(cutoffs)){
      a<-j[j[,ind]<=cutoffs[i]&j[,ind]>cutoffs[i-1],]
      ameds[[i-1]]<-apply(a,2,median)
    }
    group[[count]]<-do.call("rbind",ameds)
    count<-count+1
  }
  return(group)
}
