% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustermeds.R
\name{clustermeds}
\alias{clustermeds}
\title{Gets matrix of medians for desired measured features for all clusters meeting threshold requirements specified in Citrus}
\usage{
clustermeds(citrus.foldFeatureSet, citrus.foldClustering, medsofinterest,
  citrus.combinedFCSSet)
}
\arguments{
\item{citrus.foldFeatureSet}{computed from first two variables using citrus.calculateFoldFeatureSet function from citrus package}

\item{citrus.foldClustering}{loaded from citrusClustering.RData file generated by Citrus run}

\item{medsofinterest}{The names of the columns from citrus.combinedFCSSet$data of interest to extract medians for}

\item{citrus.combinedFCSSet}{loaded from citrusClustering.RData file generated by Citrus run}
}
\value{
Returns a matrix with columns corresponding to selected features and rows corresponding to samples
}
\description{
Gets matrix of medians for desired measured features for all clusters meeting threshold requirements specified in Citrus
}
\examples{
library(mineCitrus)
data("citrus.combinedFCSSet")
data("citrus.foldClustering")
data("citrus.foldFeatureSet")
medians<-clustermeds(citrus.foldFeatureSet=citrus.foldFeatureSet,
                     citrus.foldClustering=citrus.foldClustering,
                     medsofinterest=c("Red","Blue"),
                     citrus.combinedFCSSet=citrus.combinedFCSSet)

}
