% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findclust.R
\name{findclust}
\alias{findclust}
\title{Filters list to contain only desired clusters}
\usage{
findclust(data, clusters)
}
\arguments{
\item{data}{a list of data matrices with list elements corresponding to clusters and matrices of intensities of measured parameters}

\item{clusters}{indices of the clusters to retain}
}
\value{
A list of data matrices for the desired clusters
}
\description{
Filters list to contain only desired clusters
}
\examples{
library(mineCitrus)
data("citrus.combinedFCSSet")
data("citrus.foldClustering")
data("citrus.foldFeatureSet")
meds<-allmeds(citrus.combinedFCSSet=citrus.combinedFCSSet,
              citrus.foldClustering=citrus.foldClustering,
              citrus.foldFeatureSet=citrus.foldFeatureSet)
filteredmeds<-findclust(data=meds,clusters=c(19999,19972,19988))
}
