% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LRdate.R
\name{LRdate}
\alias{LRdate}
\title{Likelihood ratio for birth date in missing person searches}
\usage{
LRdate(
  ABD = "1976-05-31",
  DBD = "1976-07-15",
  PrelimData,
  alpha = c(1, 4, 60, 11, 6, 4, 4),
  cuts = c(-120, -30, 30, 120, 240, 360),
  draw = 500,
  type = 1,
  seed = 123
)
}
\arguments{
\item{ABD}{Actual birth date of the missing person.}

\item{DBD}{Declared birth date of the person of interest.}

\item{PrelimData}{Used when type = 2, is the dataframe with the DBD of the persons of interest in the database.}

\item{alpha}{A vector containing the alpha values for the dirichlet. It should contain the number of categories of differences between DBD and ABD.}

\item{cuts}{Value of differences between DBD and ABD used for category definition.}

\item{draw}{Number of simulations for Dirichlet distribution computation.}

\item{type}{Type of scenario, type 1 is an "open search", where it is unknown if the missing person is in the database. Type 2 refers to a scenario where the missing person is in the database.}

\item{seed}{Seed for simulations.}
}
\value{
A value of Likelihood ratio based on preliminary investigation data. In this case, birth date.
}
\description{
Likelihood ratio for birth date in missing person searches
}
\examples{
library(DirichletReg)
LRdate(ABD = "1976-05-31", DBD = "1976-07-15", 
PrelimData, alpha = c(1, 4, 60, 11, 6, 4, 4), 
cuts = c(-120, -30, 30, 120, 240, 360), 
type = 1, seed = 123)
}
