% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kl_multi.R
\name{kl_multi}
\alias{kl_multi}
\title{Multi-Population Kullback-Leibler Divergence Matrix}
\usage{
kl_multi(datasets, minFreq = 1e-10)
}
\arguments{
\item{datasets}{A list of data frames, each containing allele frequencies
for a different population. Each data frame should have "Allele" as
the first column and marker frequencies in subsequent columns.}

\item{minFreq}{Numeric. Minimum frequency to replace zeros.
Default: 1e-10.}
}
\value{
A square numeric matrix where element (i,j) contains the KL
divergence from population i to population j. Diagonal elements are 0.
}
\description{
Computes pairwise Kullback-Leibler (KL) divergence between multiple
population allele frequency databases. Returns a matrix of divergence
values useful for assessing population differentiation.
}
\details{
This function is useful for:
\itemize{
\item Comparing multiple reference populations
\item Selecting the most appropriate frequency database for a case
\item Assessing potential bias from population mismatch
}

Higher values indicate greater divergence between populations.
}
\examples{
# Compare three populations
kl_matrix <- kl_multi(list(Argentina, BosniaHerz, Europe))
print(kl_matrix)

# Visualize as heatmap
# heatmap(kl_matrix, main = "KL Divergence Between Populations")
}
\references{
Kullback S, Leibler RA (1951). "On Information and Sufficiency."
\emph{The Annals of Mathematical Statistics}, 22(1), 79-86.
}
\seealso{
\code{\link{kl_bidirectional}} for pairwise comparison of two populations.
}
