% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.missoNet.R
\name{predict.missoNet}
\alias{predict.missoNet}
\alias{predict.cv.missoNet}
\title{Predict method for \code{missoNet} models}
\usage{
\method{predict}{missoNet}(
  object,
  newx,
  s = c("lambda.min", "lambda.1se.beta", "lambda.1se.theta"),
  ...
)

\method{predict}{cv.missoNet}(
  object,
  newx,
  s = c("lambda.min", "lambda.1se.beta", "lambda.1se.theta"),
  ...
)
}
\arguments{
\item{object}{A fitted \code{missoNet} (or cross-validated \code{missoNet})
object that contains the components \code{$est.min} (and optionally
\code{$est.1se.beta}, \code{$est.1se.theta}), each with numeric fields
\code{$mu} (length \eqn{q}) and \code{$Beta} (p x q).}

\item{newx}{Numeric matrix of predictors with \eqn{p} columns (no intercept
column of 1s). Missing or non-finite values are not allowed. Columns must be in
the same order/scale used to fit \code{object}.}

\item{s}{Character string selecting the stored solution; one of
\code{c("lambda.min","lambda.1se.beta","lambda.1se.theta")}.}

\item{...}{Ignored; included for S3 compatibility.}
}
\value{
A numeric matrix of predicted responses of dimension
\eqn{n_\mathrm{new} x q}. Row names are taken from \code{newx} (if any),
and column names are inherited from the fitted coefficient matrix (if any).
}
\description{
Generate predicted responses for new observations from a fitted
\code{\link{missoNet}} (or cross-validated) model. The prediction at a given
regularization choice \eqn{(\lambda_B,\lambda_\Theta)} uses the fitted
intercept(s) \eqn{\hat{\mu}} and coefficient matrix \eqn{\hat{B}}:
\deqn{\hat{Y} = \mathbf{1}_n \hat{\mu}^{\mathsf{T}} + X_\mathrm{new}\,\hat{B}.}
}
\details{
This method does not modify or standardize \code{newx}. If the model was
trained with standardization, ensure that \code{newx} has been prepared in
the same way as the training data (same centering/scaling and column order).
}
\section{Which solution is used}{

The \code{s} argument selects the stored solution:
\itemize{
\item \code{"lambda.min"} (default): the minimum CV error or selected
GoF solution, stored in \code{object$est.min}.
\item \code{"lambda.1se.beta"}: the 1-SE solution favoring larger
\eqn{\lambda_B}, stored in \code{object$est.1se.beta}.
\item \code{"lambda.1se.theta"}: the 1-SE solution favoring larger
\eqn{\lambda_\Theta}, stored in \code{object$est.1se.theta}.
}
1-SE solutions are available only if the model was fit with
\code{compute.1se = TRUE} during training or cross-validation.
}

\examples{
sim <- generateData(n = 200, p = 8, q = 6, rho = 0.1,
                    missing.type = "MCAR", seed = 123)
tr  <- 1:150
tst <- 151:200

\donttest{
## Cross-validated fit, keeping 1-SE solutions
cvfit <- cv.missoNet(X = sim$X[tr, ], Y = sim$Z[tr, ], kfold = 5,
                     compute.1se = TRUE, verbose = 0)

## Predict on held-out set
yhat_min  <- predict(cvfit, newx = sim$X[tst, ], s = "lambda.min")
yhat_b1se <- predict(cvfit, newx = sim$X[tst, ], s = "lambda.1se.beta")
yhat_t1se <- predict(cvfit, newx = sim$X[tst, ], s = "lambda.1se.theta")
dim(yhat_min)  # 50 x q
}

}
\seealso{
\code{\link{missoNet}}, \code{\link{cv.missoNet}}, \code{\link{plot.missoNet}}
}
\keyword{models}
\keyword{regression}
